/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.LegacyRegistratorBuilder;
import xyz.apex.forge.utility.registrator.data.template.TemplatePoolBuilder;
import xyz.apex.forge.utility.registrator.data.template.TemplatePools;
import xyz.apex.forge.utility.registrator.entry.StructureEntry;
import xyz.apex.forge.utility.registrator.factory.StructureFactory;
import xyz.apex.java.utility.Apex;
import xyz.apex.java.utility.Lazy;
import xyz.apex.java.utility.nullness.NonnullFunction;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.java.utility.nullness.NonnullTriFunction;
import xyz.apex.java.utility.nullness.NonnullUnaryOperator;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class StructureBuilder<OWNER extends AbstractRegistrator<OWNER>, STRUCTURE extends Structure<FEATURE_CONFIG>, FEATURE_CONFIG extends IFeatureConfig, PARENT>
extends LegacyRegistratorBuilder<OWNER, Structure<?>, STRUCTURE, PARENT, StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT>, StructureEntry<STRUCTURE, FEATURE_CONFIG>> {
    private static final Method getCodec_Method = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
    private final StructureFactory<STRUCTURE, FEATURE_CONFIG> structureFactory;
    private final Lazy<Codec<FEATURE_CONFIG>> structureCodec;
    private final Lazy<FEATURE_CONFIG> featureConfig;
    private Supplier<StructureSeparationSettings> separationSettingsSupplier = () -> null;
    private boolean terraformTerrain = false;
    private GenerationStage.Decoration generationStage = GenerationStage.Decoration.SURFACE_STRUCTURES;
    private NonnullFunction<ServerWorld, Boolean> canDimensionGenerateStructure = level -> true;
    private Function<Biome, Boolean> canBiomeGenerate = biome -> true;
    private NonnullTriFunction<Biome.Category, BiomeAmbience, Biome.Climate, Boolean> canBiomeDataGenerate = (category, effects, climate) -> true;
    private NonnullUnaryOperator<TemplatePoolBuilder.ElementBuilder> templateElementModifier = NonnullUnaryOperator.identity();
    private final Lazy<TemplatePools> templatePool;
    private NonnullSupplier<TemplatePools> templatePoolFactory = () -> TemplatePools.of(this.owner.getModId(), this.getRegistryName());

    public StructureBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, StructureFactory<STRUCTURE, FEATURE_CONFIG> structureFactory, NonnullSupplier<Codec<FEATURE_CONFIG>> structureCodecSupplier, NonnullSupplier<FEATURE_CONFIG> featureConfigSupplier) {
        super(owner, parent, registryName, callback, Structure.class, StructureEntry::cast);
        this.structureFactory = structureFactory;
        this.structureCodec = Lazy.of(structureCodecSupplier, true);
        this.featureConfig = Lazy.of(featureConfigSupplier, true);
        this.templatePool = Lazy.of(() -> this.templatePoolFactory.get(), true);
        this.setDataGenerator(AbstractRegistrator.TEMPLATE_POOL_PROVIDER, (ctx, provider) -> ((TemplatePoolBuilder.ElementBuilder)this.templateElementModifier.apply(provider.pool(this.templatePool.get()).element().location(ctx::get))).location(ctx::get).end());
        this.onRegister(this::onRegister);
    }

    private void onRegister(STRUCTURE structure) {
        StructureSeparationSettings separationSettings;
        Structure.field_236365_a_.put((Object)this.getRegistryNameFull(), structure);
        if (this.terraformTerrain) {
            List noiseAffectingFeatures = Apex.makeMutableList(Structure.field_236384_t_);
            noiseAffectingFeatures.add(structure);
            Structure.field_236384_t_ = noiseAffectingFeatures;
        }
        if ((separationSettings = this.separationSettingsSupplier.get()) != null) {
            Map<STRUCTURE, StructureSeparationSettings> defaults = Apex.makeMutableMap(DimensionStructuresSettings.field_236191_b_);
            defaults.put(structure, separationSettings);
            DimensionStructuresSettings.field_236191_b_ = ImmutableMap.copyOf(defaults);
            for (Map.Entry entry : WorldGenRegistries.field_243658_j.func_239659_c_()) {
                DimensionStructuresSettings dimensionSettings = ((DimensionSettings)entry.getValue()).func_236108_a_();
                Map<STRUCTURE, StructureSeparationSettings> structureSettingsMap = Apex.makeMutableMap(dimensionSettings.func_236195_a_());
                structureSettingsMap.put(structure, separationSettings);
                dimensionSettings.field_236193_d_ = structureSettingsMap;
            }
        }
        Structure.field_236385_u_.put(structure, this.generationStage);
        OneTimeEventReceiver.addModListener(EventPriority.HIGH, FMLCommonSetupEvent.class, event -> {
            StructureFeature configuredFeature = structure.func_236391_a_((IFeatureConfig)this.featureConfig.get());
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)this.owner.id("configured_" + this.getRegistryName()), (Object)configuredFeature);
            FlatGenerationSettings.field_202247_j.put(structure, configuredFeature);
        });
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, WorldEvent.Load.class, event -> this.onLevelLoad((WorldEvent.Load)event, structure));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, false, BiomeLoadingEvent.class, event -> this.onBiomeLoading((BiomeLoadingEvent)event, structure));
    }

    private void onLevelLoad(WorldEvent.Load event, STRUCTURE structure) {
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld) {
            ServerWorld level = (ServerWorld)world;
            ChunkGenerator generator = level.func_72863_F().func_201711_g();
            if (StructureBuilder.isTerraForged(level)) {
                return;
            }
            if (generator instanceof FlatChunkGenerator && level.func_234923_W_() == World.field_234918_g_) {
                return;
            }
            DimensionStructuresSettings dimensionStructuresSettings = generator.func_235957_b_();
            Map structureSeparationSettingsMap = dimensionStructuresSettings.func_236195_a_();
            dimensionStructuresSettings.field_236193_d_ = Apex.makeMutableMap(structureSeparationSettingsMap);
            if (this.canDimensionGenerateStructure.apply(level).booleanValue()) {
                structureSeparationSettingsMap.putIfAbsent(structure, DimensionStructuresSettings.field_236191_b_.get(structure));
            } else {
                structureSeparationSettingsMap.remove(structure);
            }
        }
    }

    private void onBiomeLoading(BiomeLoadingEvent event, STRUCTURE structure) {
        Biome.Category category = event.getCategory();
        BiomeAmbience effects = event.getEffects();
        Biome.Climate climate = event.getClimate();
        ResourceLocation biomeName = event.getName();
        Biome biome = null;
        if (biomeName != null) {
            biome = (Biome)WorldGenRegistries.field_243657_i.func_82594_a(biomeName);
        }
        if (biome != null && !this.canBiomeGenerate.apply(biome).booleanValue()) {
            return;
        }
        if (!this.canBiomeDataGenerate.apply(category, effects, climate).booleanValue()) {
            return;
        }
        IFeatureConfig featureConfig = (IFeatureConfig)this.featureConfig.get();
        StructureFeature configured = structure.func_236391_a_(featureConfig);
        event.getGeneration().getStructures().add(() -> configured);
    }

    @Override
    protected StructureEntry<STRUCTURE, FEATURE_CONFIG> createEntryWrapper(RegistryObject<STRUCTURE> delegate) {
        return new StructureEntry(this.owner, delegate, this.templatePool.get());
    }

    public StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT> separationSettings(int spacing, int separation, int salt) {
        return this.separationSettings(() -> new StructureSeparationSettings(spacing, separation, salt));
    }

    public StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT> separationSettings(NonnullSupplier<StructureSeparationSettings> separationSettingsSupplier) {
        this.separationSettingsSupplier = separationSettingsSupplier;
        return this;
    }

    public StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT> terraformTerrain() {
        return this.terraformTerrain(true);
    }

    public StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT> terraformTerrain(boolean terraformTerrain) {
        this.terraformTerrain = terraformTerrain;
        return this;
    }

    public StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT> generationStage(GenerationStage.Decoration generationStage) {
        this.generationStage = generationStage;
        return this;
    }

    public StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT> canDimensionGenerate(NonnullFunction<ServerWorld, Boolean> canDimensionGenerateStructure) {
        this.canDimensionGenerateStructure = canDimensionGenerateStructure;
        return this;
    }

    public StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT> canBiomeGenerate(NonnullFunction<Biome, Boolean> canBiomeGenerate) {
        this.canBiomeGenerate = canBiomeGenerate;
        return this;
    }

    public StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT> canBiomeGenerate(NonnullTriFunction<Biome.Category, BiomeAmbience, Biome.Climate, Boolean> canBiomeDataGenerate) {
        this.canBiomeDataGenerate = canBiomeDataGenerate;
        return this;
    }

    public StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT> templatePool(NonnullSupplier<TemplatePools> templatePoolFactory) {
        this.templatePool.invalidate();
        this.templatePoolFactory = templatePoolFactory;
        return this;
    }

    public StructureBuilder<OWNER, STRUCTURE, FEATURE_CONFIG, PARENT> templateElement(NonnullUnaryOperator<TemplatePoolBuilder.ElementBuilder> templateElementModifier) {
        this.templateElementModifier = this.templateElementModifier.andThen(templateElementModifier);
        return this;
    }

    @Override
    @NonnullType
    protected STRUCTURE createEntry() {
        return this.structureFactory.create(this.structureCodec.get());
    }

    private static boolean isTerraForged(ServerWorld level) {
        try {
            ChunkGenerator generator = level.func_72863_F().func_201711_g();
            Codec codec = (Codec)getCodec_Method.invoke((Object)generator, new Object[0]);
            ResourceLocation generatorName = Registry.field_239690_aB_.func_177774_c((Object)codec);
            return generatorName != null && generatorName.func_110624_b().equalsIgnoreCase("terraforged");
        }
        catch (Exception e) {
            return false;
        }
    }
}

