/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.helper;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import org.apache.commons.lang3.Validate;
import xyz.apex.java.utility.Lazy;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public final class ArmorMaterial
implements IArmorMaterial {
    public static final int[] HEALTH_PER_SLOT = net.minecraft.item.ArmorMaterial.field_77882_bY;
    public static final EquipmentSlotType[] ARMOR_SLOT_TYPES = (EquipmentSlotType[])Arrays.stream(EquipmentSlotType.values()).filter(slotType -> slotType.func_188453_a() == EquipmentSlotType.Group.ARMOR).toArray(EquipmentSlotType[]::new);
    public final ResourceLocation name;
    public final int durabilityMultiplier;
    public final int[] slotProtections;
    public final int enchantmentValue;
    public final Lazy<SoundEvent> sound;
    public final float toughness;
    public final float knockbackResistance;
    public final Lazy<Ingredient> repairIngredient;

    public ArmorMaterial(ResourceLocation name, int durabilityMultiplier, int[] slotProtections, int enchantmentValue, NonnullSupplier<SoundEvent> sound, float toughness, float knockbackResistance, NonnullSupplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.slotProtections = slotProtections;
        this.enchantmentValue = enchantmentValue;
        this.sound = Lazy.of(sound, true);
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = Lazy.of(repairIngredient, true);
    }

    private ArmorMaterial(Builder builder) {
        this.name = builder.name;
        this.durabilityMultiplier = builder.durabilityMultiplier;
        this.enchantmentValue = builder.enchantmentValue;
        this.toughness = builder.toughness;
        this.knockbackResistance = builder.knockbackResistance;
        this.sound = Lazy.of(builder.sound, true);
        this.repairIngredient = Lazy.of(builder.repairIngredient, true);
        this.slotProtections = builder.slotDefenseMap.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((EquipmentSlotType)entry.getKey()).func_188454_b())).mapToInt(Map.Entry::getValue).toArray();
    }

    public int func_200896_a(EquipmentSlotType slotType) {
        return HEALTH_PER_SLOT[slotType.func_188454_b()] * this.durabilityMultiplier;
    }

    public int func_200902_b(EquipmentSlotType slotType) {
        return this.slotProtections[slotType.func_188454_b()];
    }

    public int func_200900_a() {
        return this.enchantmentValue;
    }

    public SoundEvent func_200899_b() {
        return this.sound.get();
    }

    public Ingredient func_200898_c() {
        return this.repairIngredient.get();
    }

    public String func_200897_d() {
        return this.name.toString();
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return this.knockbackResistance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArmorMaterial that = (ArmorMaterial)o;
        return this.durabilityMultiplier == that.durabilityMultiplier && this.enchantmentValue == that.enchantmentValue && Float.compare(that.toughness, this.toughness) == 0 && Float.compare(that.knockbackResistance, this.knockbackResistance) == 0 && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.slotProtections, (Object)that.slotProtections) && Objects.equal(this.sound, that.sound) && Objects.equal(this.repairIngredient, that.repairIngredient);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.durabilityMultiplier, this.slotProtections, this.enchantmentValue, this.sound, Float.valueOf(this.toughness), Float.valueOf(this.knockbackResistance), this.repairIngredient});
    }

    public String toString() {
        return "ArmorMaterial{name=" + this.name + ", durabilityMultiplier=" + this.durabilityMultiplier + ", slotProtections=" + Arrays.toString(this.slotProtections) + ", enchantmentValue=" + this.enchantmentValue + ", sound=" + this.sound + ", toughness=" + this.toughness + ", knockbackResistance=" + this.knockbackResistance + ", repairIngredient=" + this.repairIngredient + '}';
    }

    public static Builder builder(ResourceLocation name) {
        return new Builder(name);
    }

    public static Builder builder(String namespace, String name) {
        return ArmorMaterial.builder(new ResourceLocation(namespace, name));
    }

    public static Builder copy(ResourceLocation name, IArmorMaterial armorMaterial) {
        return ArmorMaterial.builder(name).copy(armorMaterial);
    }

    public static Builder copy(String namespace, String name, IArmorMaterial armorMaterial) {
        return ArmorMaterial.copy(new ResourceLocation(namespace, name), armorMaterial);
    }

    public static int getDurabilityMultiplierForSlot(IArmorMaterial armorMaterial, EquipmentSlotType slotType) {
        return armorMaterial.func_200896_a(slotType) / HEALTH_PER_SLOT[slotType.func_188454_b()];
    }

    public static final class Builder {
        private final Map<EquipmentSlotType, Integer> slotDefenseMap = Maps.newEnumMap(EquipmentSlotType.class);
        private final ResourceLocation name;
        private int durabilityMultiplier = -1;
        private int enchantmentValue = -1;
        private NonnullSupplier<SoundEvent> sound = () -> SoundEvents.field_187719_p;
        private float toughness = -1.0f;
        private float knockbackResistance = -1.0f;
        private NonnullSupplier<Ingredient> repairIngredient = () -> Ingredient.field_193370_a;

        private Builder(ResourceLocation name) {
            this.name = name;
        }

        public Builder copy(Builder builder) {
            this.slotDefenseMap.clear();
            this.slotDefenseMap.putAll(builder.slotDefenseMap);
            return this.durabilityMultiplier(builder.durabilityMultiplier).enchantmentValue(builder.enchantmentValue).sound(builder.sound).toughness(builder.toughness).knockbackResistance(builder.knockbackResistance).repairIngredient(builder.repairIngredient);
        }

        public Builder copy(IArmorMaterial armorMaterial) {
            this.slotDefenseMap.clear();
            Arrays.stream(ARMOR_SLOT_TYPES).forEach(slotType -> this.defenseForSlot((EquipmentSlotType)slotType, armorMaterial.func_200902_b(slotType)));
            int durabilityMultiplier = Arrays.stream(ARMOR_SLOT_TYPES).mapToInt(slotType -> ArmorMaterial.getDurabilityMultiplierForSlot(armorMaterial, slotType)).max().orElse(0);
            return this.durabilityMultiplier(durabilityMultiplier).enchantmentValue(armorMaterial.func_200900_a()).sound(() -> ((IArmorMaterial)armorMaterial).func_200899_b()).toughness(armorMaterial.func_200901_e()).knockbackResistance(armorMaterial.func_230304_f_()).repairIngredient(() -> ((IArmorMaterial)armorMaterial).func_200898_c());
        }

        public Builder defenseForSlot(EquipmentSlotType slotType, int slotDefense) {
            Validate.isTrue((slotType.func_188453_a() == EquipmentSlotType.Group.ARMOR ? 1 : 0) != 0);
            this.slotDefenseMap.put(slotType, slotDefense);
            return this;
        }

        public Builder durabilityMultiplier(int durabilityMultiplier) {
            this.durabilityMultiplier = durabilityMultiplier;
            return this;
        }

        public Builder enchantmentValue(int enchantmentValue) {
            this.enchantmentValue = enchantmentValue;
            return this;
        }

        public Builder sound(NonnullSupplier<SoundEvent> sound) {
            this.sound = sound;
            return this;
        }

        public Builder toughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public Builder knockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        public Builder repairIngredient(NonnullSupplier<Ingredient> repairIngredient) {
            this.repairIngredient = repairIngredient;
            return this;
        }

        public Builder repairIngredient(ITag<Item> repairIngredient) {
            return this.repairIngredient(() -> Ingredient.func_199805_a((ITag)repairIngredient));
        }

        public Builder repairIngredient(IItemProvider ... repairIngredients) {
            return this.repairIngredient(() -> Ingredient.func_199804_a((IItemProvider[])repairIngredients));
        }

        public IArmorMaterial build() {
            return new ArmorMaterial(this);
        }
    }
}

