/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.helper;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.entry.ItemProviderEntry;
import xyz.apex.java.utility.Lazy;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;

public class RegistratorItemGroup
extends ItemGroup
implements Lazy<ItemStack> {
    protected final AbstractRegistrator<?> registrator;
    private int cycleTime = 0;
    private final int maxCycleTime;
    private final Set<ItemStack> allIcons = Sets.newHashSet();
    private final Stack<ItemStack> icons = new Stack();

    protected RegistratorItemGroup(AbstractRegistrator<?> registrator, @Nullable String labelSuffix, int maxCycleTime) {
        super(RegistratorItemGroup.buildLabel(registrator, labelSuffix));
        this.registrator = registrator;
        this.maxCycleTime = maxCycleTime;
        registrator.backend.addRegisterCallback(Item.class, this::initialize);
    }

    @Override
    public ItemStack get() {
        if (this.icons.isEmpty()) {
            return Items.field_221574_b.func_190903_i();
        }
        return this.icons.peek();
    }

    @Override
    public void invalidate() {
        this.icons.clear();
        this.icons.addAll(this.allIcons);
        Collections.shuffle(this.icons);
        this.cycleTime = 0;
    }

    private void initialize() {
        for (RegistryEntry<Item> registryEntry : this.registrator.getAll(Item.class)) {
            if (registryEntry instanceof ItemProviderEntry) {
                this.allIcons.add(((ItemProviderEntry)registryEntry).asItemStack());
                continue;
            }
            if (!(registryEntry instanceof xyz.apex.repack.com.tterrag.registrate.util.entry.ItemProviderEntry)) continue;
            this.allIcons.add(((xyz.apex.repack.com.tterrag.registrate.util.entry.ItemProviderEntry)registryEntry).asStack());
        }
        this.invalidate();
    }

    public ItemStack func_151244_d() {
        ++this.cycleTime;
        if (this.cycleTime >= this.maxCycleTime) {
            this.cycleTime = 0;
            ItemStack iconItemStack = this.icons.pop();
            RegistratorItemGroup.setIconItemStack(this, iconItemStack);
            if (this.icons.isEmpty()) {
                this.invalidate();
            }
        }
        return super.func_151244_d();
    }

    public ItemStack func_78016_d() {
        return this.get();
    }

    private static String buildLabel(AbstractRegistrator<?> registrator, @Nullable String labelSuffix) {
        if (StringUtils.isEmpty((CharSequence)labelSuffix) || StringUtils.isBlank((CharSequence)labelSuffix)) {
            return registrator.getModId();
        }
        return registrator.idString(labelSuffix).replace(':', '.');
    }

    public static ItemGroup create(AbstractRegistrator<?> registrator, String labelSuffix, int maxCycleTime) {
        return new RegistratorItemGroup(registrator, labelSuffix, maxCycleTime);
    }

    public static ItemGroup create(AbstractRegistrator<?> registrator, String labelSuffix) {
        return RegistratorItemGroup.create(registrator, labelSuffix, 75);
    }

    public static ItemGroup create(AbstractRegistrator<?> registrator, int maxCycleTime) {
        return new RegistratorItemGroup(registrator, null, maxCycleTime);
    }

    public static ItemGroup create(AbstractRegistrator<?> registrator) {
        return RegistratorItemGroup.create(registrator, 75);
    }

    public static ItemStack getIconItemStack(ItemGroup itemGroup) {
        ItemStack iconItemStack = itemGroup.field_151245_t;
        Validate.notNull((Object)iconItemStack);
        return iconItemStack;
    }

    public static ItemStack setIconItemStack(ItemGroup itemGroup, ItemStack iconItemStack) {
        ItemStack oldItemIconStack = RegistratorItemGroup.getIconItemStack(itemGroup);
        itemGroup.field_151245_t = iconItemStack;
        return oldItemIconStack;
    }
}

