/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.java.utility;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xyz.apex.java.utility.nullness.NonnullUnaryOperator;

public final class Apex {
    public static <V> List<V> makeImmutableList(NonnullUnaryOperator<ImmutableList.Builder<V>> consumer) {
        return ((ImmutableList.Builder)consumer.apply(ImmutableList.builder())).build();
    }

    public static <V> List<V> makeImmutableList(List<V> list) {
        if (list instanceof ImmutableList) {
            return list;
        }
        return Apex.makeImmutableList(builder -> builder.addAll((Iterable)list));
    }

    public static <V> List<V> makeMutableList(List<V> list) {
        if (list instanceof ImmutableList) {
            return Lists.newArrayList(list);
        }
        return list;
    }

    public static <V> Set<V> makeImmutableSet(NonnullUnaryOperator<ImmutableSet.Builder<V>> consumer) {
        return ((ImmutableSet.Builder)consumer.apply(ImmutableSet.builder())).build();
    }

    public static <V> Set<V> makeImmutableSet(Set<V> set) {
        if (set instanceof ImmutableSet) {
            return set;
        }
        return Apex.makeImmutableSet(builder -> builder.addAll((Iterable)set));
    }

    public static <V> Set<V> makeMutableSet(Set<V> set) {
        if (set instanceof ImmutableSet) {
            return Sets.newHashSet(set);
        }
        return set;
    }

    public static <K, V> Map<K, V> makeImmutableMap(NonnullUnaryOperator<ImmutableMap.Builder<K, V>> consumer) {
        return ((ImmutableMap.Builder)consumer.apply(ImmutableMap.builder())).build();
    }

    public static <K, V> Map<K, V> makeImmutableMap(Map<K, V> map) {
        if (map instanceof ImmutableMap) {
            return map;
        }
        return Apex.makeImmutableMap(builder -> builder.putAll(map));
    }

    public static <K, V> Map<K, V> makeMutableMap(Map<K, V> map) {
        if (map instanceof ImmutableMap) {
            return Maps.newHashMap(map);
        }
        return map;
    }
}

