/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.IMultiBlock;

public final class MultiBlockPattern {
    public static final int INDEX_ORIGIN = 0;
    private final List<BlockPos> localPositions;
    private final IntegerProperty blockProperty;
    private final QuadFunction<IMultiBlock, MultiBlockPattern, BlockState, BlockPos, BlockPos> worldSpaceFromLocalSpace;
    private final QuadFunction<IMultiBlock, MultiBlockPattern, BlockState, BlockPos, BlockPos> originFromWorldSpace;
    private final QuadFunction<MultiBlockPattern, BlockPos, BlockState, Integer, BlockState> placementStateModifier;
    private final QuadPredicate<IMultiBlock, LevelReader, BlockPos, BlockState> placementPredicate;
    private final boolean placeSoundPerBlock;

    private MultiBlockPattern(Builder builder) {
        this.worldSpaceFromLocalSpace = builder.worldSpaceFromLocalSpace;
        this.originFromWorldSpace = builder.originFromWorldSpace;
        this.placementPredicate = builder.placementPredicate;
        this.placeSoundPerBlock = builder.placeSoundPerBlock;
        this.placementStateModifier = builder.placementStateModifier;
        ImmutableList.Builder list = ImmutableList.builder();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < builder.layers.size(); ++y) {
            String[] patterns = builder.layers.get(y);
            pos.m_142448_(y);
            for (int x = 0; x < patterns.length; ++x) {
                String pattern = patterns[x];
                pos.m_142451_(x);
                for (int z = 0; z < pattern.length(); ++z) {
                    char token = pattern.charAt(z);
                    pos.m_142443_(z);
                    if (Character.isWhitespace(token)) continue;
                    list.add((Object)pos.m_7949_());
                }
            }
        }
        this.localPositions = list.build();
        this.blockProperty = IntegerProperty.m_61631_((String)"multi_block_index", (int)0, (int)this.localPositions.size());
    }

    @Nullable
    BlockState getStateForPlacement(IMultiBlock multiBlock, BlockState placementBlockState, BlockPlaceContext ctx) {
        if (this.hasIndexProperty(placementBlockState)) {
            Level level = ctx.m_43725_();
            BlockPos origin = ctx.m_8083_();
            for (int i = 0; i < this.localPositions.size(); ++i) {
                BlockState worldBlockState;
                BlockState testBlockState;
                BlockPos localSpace = this.localPositions.get(i);
                BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(multiBlock, placementBlockState, origin, localSpace);
                if (this.passesPlacementTests(multiBlock, (LevelReader)level, worldSpace, testBlockState = this.setIndex(placementBlockState, i), worldBlockState = level.m_8055_(worldSpace))) continue;
                return null;
            }
            return placementBlockState;
        }
        return null;
    }

    boolean canSurvive(IMultiBlock multiBlock, LevelReader level, BlockPos pos, BlockState blockState) {
        if (this.hasIndexProperty(blockState)) {
            int index = this.getIndex(blockState);
            BlockPos origin = this.getOriginFromWorldSpace(multiBlock, blockState, pos, this.localPositions.get(index));
            for (int i = 0; i < this.localPositions.size(); ++i) {
                BlockState worldBlockState;
                BlockState testBlockState;
                BlockPos localSpace = this.localPositions.get(i);
                BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(multiBlock, blockState, origin, localSpace);
                if (this.passesPlacementTests(multiBlock, level, worldSpace, testBlockState = this.setIndex(blockState, i), worldBlockState = level.m_8055_(worldSpace))) continue;
                return false;
            }
        }
        return true;
    }

    void onPlace(IMultiBlock multiBlock, BlockState blockState, Level level, BlockPos origin, BlockState oldBlockState) {
        if (this.hasIndexProperty(blockState) && !oldBlockState.m_60713_(multiBlock.asBlock()) && this.getIndex(blockState) == 0) {
            SoundType soundType = blockState.getSoundType((LevelReader)level, origin, null);
            SoundEvent placeSound = soundType.m_56777_();
            for (int i = 1; i < this.localPositions.size(); ++i) {
                BlockPos localSpace = this.localPositions.get(i);
                BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(multiBlock, blockState, origin, localSpace);
                BlockState placementBlockState = this.setIndex(blockState, i);
                placementBlockState = this.placementStateModifier.apply(this, worldSpace, placementBlockState, i);
                level.m_7731_(worldSpace, placementBlockState, 11);
                if (!this.placeSoundPerBlock) continue;
                level.m_5594_(null, worldSpace, placeSound, SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            }
        }
    }

    void onRemove(IMultiBlock multiBlock, BlockState blockState, Level level, BlockPos pos, BlockState newBlockState) {
        Block block;
        if (!(!this.hasIndexProperty(blockState) || blockState.m_60713_(block = multiBlock.asBlock()) && newBlockState.m_60713_(block))) {
            int index = this.getIndex(blockState);
            BlockPos origin = this.getOriginFromWorldSpace(multiBlock, blockState, pos, this.localPositions.get(index));
            for (BlockPos localSpace : this.localPositions) {
                BlockPos worldSpace = this.getWorldSpaceFromLocalSpace(multiBlock, blockState, origin, localSpace);
                if (worldSpace.equals((Object)pos) || !level.m_8055_(worldSpace).m_60713_(block)) continue;
                level.m_46961_(worldSpace, false);
            }
        }
    }

    void registerProperties(Consumer<Property<?>> consumer) {
        consumer.accept((Property<?>)this.blockProperty);
    }

    BlockState registerDefaultState(BlockState state) {
        return this.setIndex(state, 0);
    }

    public boolean passesPlacementTests(IMultiBlock multiBlock, LevelReader level, BlockPos pos, BlockState multiBlockState, BlockState worldBlockState) {
        if (this.hasIndexProperty(multiBlockState)) {
            if (!worldBlockState.m_60767_().m_76336_()) {
                return false;
            }
            if (this.placementPredicate.test(multiBlock, level, pos, worldBlockState)) {
                return true;
            }
        }
        return false;
    }

    public int getIndex(BlockState blockState) {
        return blockState.m_61145_((Property)this.blockProperty).orElse(0);
    }

    public BlockState setIndex(BlockState blockState, int index) {
        return this.hasIndexProperty(blockState) ? (BlockState)blockState.m_61124_((Property)this.blockProperty, (Comparable)Integer.valueOf(index)) : blockState;
    }

    public boolean hasIndexProperty(BlockState blockState) {
        return blockState.m_61138_((Property)this.blockProperty);
    }

    public boolean isOrigin(BlockState blockState) {
        return this.getIndex(blockState) == 0;
    }

    public BlockPos getWorldSpaceFromLocalSpace(IMultiBlock multiBlock, BlockState blockState, BlockPos origin, BlockPos localSpace) {
        if (this.hasIndexProperty(blockState)) {
            BlockPos newLocalSpace = this.worldSpaceFromLocalSpace.apply(multiBlock, this, blockState, localSpace);
            return origin.m_141952_((Vec3i)newLocalSpace);
        }
        return origin;
    }

    public BlockPos getOriginFromWorldSpace(IMultiBlock multiBlock, BlockState blockState, BlockPos worldSpace, BlockPos localSpace) {
        if (this.hasIndexProperty(blockState)) {
            BlockPos newLocalSpace = this.originFromWorldSpace.apply(multiBlock, this, blockState, localSpace);
            return worldSpace.m_141950_((Vec3i)newLocalSpace);
        }
        return worldSpace;
    }

    public List<BlockPos> getLocalPositions() {
        return this.localPositions;
    }

    public BlockPos getOriginPos(IMultiBlock multiBlock, BlockState blockState, BlockPos worldSpace) {
        if (this.hasIndexProperty(blockState)) {
            int index = this.getIndex(blockState);
            BlockPos localSpace = this.localPositions.get(index);
            return this.getOriginFromWorldSpace(multiBlock, blockState, worldSpace, localSpace);
        }
        return worldSpace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BlockPos getMultiBlockWorldSpaceFromLocalSpace(IMultiBlock multiBlock, MultiBlockPattern pattern, BlockState blockState, BlockPos pos) {
        if (multiBlock.hasMultiBlockIndexProperty(blockState) && BaseBlock.supportsFacing(blockState)) {
            return switch (BaseBlock.getFacing(blockState)) {
                case Direction.NORTH -> pos.m_7954_(Rotation.CLOCKWISE_90);
                case Direction.SOUTH -> pos.m_7954_(Rotation.COUNTERCLOCKWISE_90);
                case Direction.EAST -> pos.m_7954_(Rotation.CLOCKWISE_180);
                default -> pos;
            };
        }
        return pos;
    }

    public static BlockPos getMultiBlockOriginFromWorldSpace(IMultiBlock multiBlock, MultiBlockPattern pattern, BlockState blockState, BlockPos pos) {
        if (multiBlock.hasMultiBlockIndexProperty(blockState) && BaseBlock.supportsFacing(blockState)) {
            return switch (BaseBlock.getFacing(blockState)) {
                case Direction.NORTH -> pos.m_7954_(Rotation.CLOCKWISE_90);
                case Direction.SOUTH -> pos.m_7954_(Rotation.COUNTERCLOCKWISE_90);
                case Direction.EAST -> pos.m_7954_(Rotation.CLOCKWISE_180);
                default -> pos;
            };
        }
        return pos;
    }

    public static final class Builder {
        private final List<String[]> layers = Lists.newArrayList();
        private QuadFunction<IMultiBlock, MultiBlockPattern, BlockState, BlockPos, BlockPos> worldSpaceFromLocalSpace = MultiBlockPattern::getMultiBlockWorldSpaceFromLocalSpace;
        private QuadFunction<IMultiBlock, MultiBlockPattern, BlockState, BlockPos, BlockPos> originFromWorldSpace = MultiBlockPattern::getMultiBlockOriginFromWorldSpace;
        private QuadFunction<MultiBlockPattern, BlockPos, BlockState, Integer, BlockState> placementStateModifier = (pattern, pos, blockState, integer) -> blockState;
        private QuadPredicate<IMultiBlock, LevelReader, BlockPos, BlockState> placementPredicate = (multiBlock, level, pos, blockState) -> true;
        private boolean placeSoundPerBlock = false;

        private Builder() {
        }

        public Builder layer(String ... layers) {
            Collections.addAll(this.layers, new String[][]{layers});
            return this;
        }

        public Builder worldSpaceFromLocalSpace(QuadFunction<IMultiBlock, MultiBlockPattern, BlockState, BlockPos, BlockPos> worldSpaceFromLocalSpace) {
            this.worldSpaceFromLocalSpace = worldSpaceFromLocalSpace;
            return this;
        }

        public Builder originFromWorldSpace(QuadFunction<IMultiBlock, MultiBlockPattern, BlockState, BlockPos, BlockPos> originFromWorldSpace) {
            this.originFromWorldSpace = originFromWorldSpace;
            return this;
        }

        public Builder placementStateModifier(QuadFunction<MultiBlockPattern, BlockPos, BlockState, Integer, BlockState> placementStateModifier) {
            this.placementStateModifier = placementStateModifier;
            return this;
        }

        public Builder placementPredicate(QuadPredicate<IMultiBlock, LevelReader, BlockPos, BlockState> placementPredicate) {
            this.placementPredicate = placementPredicate;
            return this;
        }

        public Builder placeSoundPerBlock() {
            this.placeSoundPerBlock = true;
            return this;
        }

        public MultiBlockPattern build() {
            return new MultiBlockPattern(this);
        }
    }

    @FunctionalInterface
    public static interface QuadFunction<A, B, C, D, RESULT> {
        public RESULT apply(A var1, B var2, C var3, D var4);

        default public <RETURN> QuadFunction<A, B, C, D, RETURN> andThen(Function<? super RESULT, ? extends RETURN> after) {
            Objects.requireNonNull(after);
            return (a, b, c, d) -> after.apply((RESULT)this.apply(a, b, c, d));
        }
    }

    @FunctionalInterface
    public static interface QuadPredicate<A, B, C, D>
    extends QuadFunction<A, B, C, D, Boolean> {
        public boolean test(A var1, B var2, C var3, D var4);

        @Override
        default public Boolean apply(A a, B b, C c, D d) {
            return this.test(a, b, c, d);
        }

        default public QuadPredicate<A, B, C, D> and(QuadPredicate<? super A, ? super B, ? super C, ? super D> other) {
            Objects.requireNonNull(other);
            return (a, b, c, d) -> this.test(a, b, c, d) && other.test(a, b, c, d);
        }

        default public QuadPredicate<A, B, C, D> negate() {
            return (a, b, c, d) -> !this.test(a, b, c, d);
        }

        default public QuadPredicate<A, B, C, D> or(QuadPredicate<? super A, ? super B, ? super C, ? super D> other) {
            Objects.requireNonNull(other);
            return (a, b, c, d) -> this.test(a, b, c, d) || other.test(a, b, c, d);
        }
    }
}

