/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;

public class WallLightBlock
extends BaseBlock {
    public WallLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
        BlockState blockState = super.modifyPlacementState(placementBlockState, ctx);
        if (blockState != null && WallLightBlock.supportsFacing(blockState)) {
            Direction[] nearestLookingDirections;
            Level level = ctx.m_43725_();
            BlockPos pos = ctx.m_8083_();
            for (Direction direction : nearestLookingDirections = ctx.m_6232_()) {
                Direction opposite;
                BlockState modifiedBlockState;
                if (!direction.m_122434_().m_122479_() || !(modifiedBlockState = WallLightBlock.setFacing(blockState, opposite = direction.m_122424_())).m_60710_((LevelReader)level, pos)) continue;
                return modifiedBlockState;
            }
        }
        return blockState;
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos pos) {
        if (WallLightBlock.supportsFacing(blockState)) {
            Direction facing = WallLightBlock.getFacing(blockState);
            BlockPos oppositePos = pos.m_142300_(facing.m_122424_());
            BlockState oppositeBlockState = level.m_8055_(oppositePos);
            return oppositeBlockState.m_60783_((BlockGetter)level, oppositePos, facing);
        }
        return super.m_7898_(blockState, level, pos);
    }

    public void m_7100_(BlockState blockState, Level level, BlockPos pos, Random rng) {
        if (WallLightBlock.supportsWaterLogging(blockState) && WallLightBlock.isWaterLogged(blockState)) {
            return;
        }
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        this.spawnLightParticles(level, pos, blockState, x, y, z, rng);
    }

    protected void spawnLightParticles(Level level, BlockPos pos, BlockState blockState, double pX, double pY, double pZ, Random rng) {
        double x = pX;
        double y = pY;
        double z = pZ;
        if (WallLightBlock.supportsFacing(blockState)) {
            Direction facing = WallLightBlock.getFacing(blockState).m_122424_();
            double hStep = 0.12;
            double vStep = 0.24;
            x = pX + hStep * (double)facing.m_122429_();
            y = pY + 0.2 + vStep;
            z = pZ + hStep * (double)facing.m_122431_();
        }
        this.onLightParticle(level, pos, blockState, x, y, z, rng);
    }

    protected void onLightParticle(Level level, BlockPos pos, BlockState blockState, double pX, double pY, double pZ, Random rng) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pX, pY, pZ, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pX, pY, pZ, 0.0, 0.0, 0.0);
    }
}

