/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.util.NameableMutable;

public class BaseBlockEntity
extends BlockEntity {
    public static final String NBT_APEX = "ApexData";

    protected BaseBlockEntity(BlockEntityType<? extends BaseBlockEntity> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    protected CompoundTag serializeData() {
        return new CompoundTag();
    }

    protected void deserializeData(CompoundTag tagCompound) {
    }

    public final void m_183515_(CompoundTag tagCompound) {
        tagCompound.m_128365_(NBT_APEX, (Tag)this.serializeData());
    }

    public final void m_142466_(CompoundTag tagCompound) {
        if (tagCompound.m_128425_(NBT_APEX, 10)) {
            this.deserializeData(tagCompound.m_128469_(NBT_APEX));
        }
        super.m_142466_(tagCompound);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public final CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        updateTag.m_128365_(NBT_APEX, (Tag)this.serializeData());
        return updateTag;
    }

    public final void handleUpdateTag(CompoundTag updateTag) {
        if (updateTag.m_128425_(NBT_APEX, 10)) {
            this.deserializeData(updateTag.m_128469_(NBT_APEX));
        }
        super.handleUpdateTag(updateTag);
    }

    public static class WithCustomName
    extends BaseBlockEntity
    implements NameableMutable {
        public static final String NBT_CUSTOM_NAME = "CustomName";
        @Nullable
        private Component customName = null;

        protected WithCustomName(BlockEntityType<? extends WithCustomName> blockEntityType, BlockPos pos, BlockState blockState) {
            super(blockEntityType, pos, blockState);
        }

        @Override
        public void setCustomName(@Nullable Component customName) {
            this.customName = customName;
        }

        @Nullable
        public Component m_7770_() {
            return this.customName;
        }

        public Component m_5446_() {
            return this.customName == null ? this.m_7755_() : this.customName;
        }

        public Component m_7755_() {
            return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
        }

        @Override
        @MustBeInvokedByOverriders
        protected CompoundTag serializeData() {
            CompoundTag tagCompound = super.serializeData();
            if (this.customName != null) {
                String customNameJson = Component.Serializer.m_130703_((Component)this.customName);
                tagCompound.m_128359_(NBT_CUSTOM_NAME, customNameJson);
            }
            return tagCompound;
        }

        @Override
        @MustBeInvokedByOverriders
        protected void deserializeData(CompoundTag tagCompound) {
            if (tagCompound.m_128425_(NBT_CUSTOM_NAME, 8)) {
                String customNameJson = tagCompound.m_128461_(NBT_CUSTOM_NAME);
                this.customName = Component.Serializer.m_130701_((String)customNameJson);
            }
            super.deserializeData(tagCompound);
        }
    }
}

