/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.item;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;

public final class ItemGroupCategory
implements Predicate<ItemStack> {
    private static final int cycleTime = 1000;
    private final Builder builder;
    private final Map<CreativeModeTab, NonNullList<ItemStack>> categoryIcons = Maps.newHashMap();
    private long cycleStartTime;
    private long cycleTickTime;
    private long cyclePausedDuration = 0L;
    private final boolean cycleIcons;
    private final Lazy<ItemStack> defaultIcon;

    private ItemGroupCategory(Builder builder) {
        this.builder = builder;
        this.defaultIcon = Lazy.of(() -> builder.defaultIcon == null ? Items.f_42127_.m_7968_() : builder.defaultIcon.get());
        this.cycleIcons = builder.cycleIcons;
        this.cycleTickTime = System.currentTimeMillis();
        this.cycleStartTime = this.cycleTickTime - (long)builder.cycleOffset * 1000L;
    }

    private NonNullList<ItemStack> getCategoryIcons(CreativeModeTab itemGroup) {
        NonNullList itemGroupItems = NonNullList.m_122779_();
        NonNullList icons = NonNullList.m_122779_();
        itemGroup.m_6151_(itemGroupItems);
        for (ItemStack stack : itemGroupItems) {
            if (!this.test(stack)) continue;
            icons.add((Object)stack);
        }
        ItemStack defaultIcon = (ItemStack)this.defaultIcon.get();
        if (icons.isEmpty()) {
            icons.add((Object)defaultIcon);
        } else {
            for (ItemStack icon : icons) {
                if (!ItemStack.m_41746_((ItemStack)icon, (ItemStack)defaultIcon)) continue;
                return icons;
            }
            icons.add((Object)defaultIcon);
        }
        return icons;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.builder.categoryPredicate.test(stack);
    }

    public boolean isCyclingIcons() {
        return this.cycleIcons;
    }

    public void tick(boolean doCycle) {
        if (this.cycleIcons) {
            if (this.cycleIcons) {
                if (this.cyclePausedDuration > 0L) {
                    this.cycleStartTime += this.cyclePausedDuration;
                    this.cyclePausedDuration = 0L;
                }
                this.cycleTickTime = System.currentTimeMillis();
            } else {
                this.cyclePausedDuration = System.currentTimeMillis() - this.cycleTickTime;
            }
        }
    }

    public ItemStack getCategoryIcon(CreativeModeTab itemGroup) {
        if (this.cycleIcons) {
            NonNullList icons = this.categoryIcons.computeIfAbsent(itemGroup, this::getCategoryIcons);
            if (icons.isEmpty()) {
                return (ItemStack)this.defaultIcon.get();
            }
            long index = (this.cycleTickTime - this.cycleStartTime) / 1000L % (long)icons.size();
            return (ItemStack)icons.get(Math.toIntExact(index));
        }
        return (ItemStack)this.defaultIcon.get();
    }

    public String getCategoryNameKey() {
        return "itemGroup.category." + this.builder.categoryName;
    }

    public Component getCategoryName() {
        String categoryNameKey = this.getCategoryNameKey();
        return new TranslatableComponent(categoryNameKey);
    }

    public <T extends AbstractRegistrate<T>> ItemGroupCategory addTranslationGenerator(T registrator, String englishName) {
        ((AbstractRegistrate)registrator).addDataGenerator(ProviderType.LANG, provider -> provider.add(this.getCategoryNameKey(), englishName));
        return this;
    }

    public static Builder builder(String categoryName) {
        return new Builder(categoryName);
    }

    public static final class Builder {
        private final String categoryName;
        private int cycleOffset = (int)(Math.random() * 10000.0 % 2.147483647E9);
        private boolean cycleIcons = false;
        private Predicate<ItemStack> categoryPredicate = stack -> true;
        @Nullable
        private Supplier<ItemStack> defaultIcon;

        private Builder(String categoryName) {
            this.categoryName = categoryName;
        }

        public Builder predicate(Predicate<ItemStack> categoryPredicate) {
            this.categoryPredicate = categoryPredicate;
            return this;
        }

        public Builder defaultIcon(Supplier<ItemStack> defaultIcon) {
            this.defaultIcon = defaultIcon;
            return this;
        }

        public Builder tagged(TagKey<Item> itemTag) {
            return this.predicate(s -> s.m_204117_(itemTag));
        }

        public Builder cycleOffset(int cycleOffset) {
            this.cycleIcons = true;
            this.cycleOffset = cycleOffset;
            return this;
        }

        public Builder cycleIcons() {
            this.cycleIcons = true;
            return this;
        }

        public ItemGroupCategory build() {
            return new ItemGroupCategory(this);
        }
    }
}

