/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.repack.com.tterrag.registrate.builders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.builders.AbstractBuilder;
import xyz.apex.repack.com.tterrag.registrate.builders.BlockEntityBuilder;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.builders.ItemBuilder;
import xyz.apex.repack.com.tterrag.registrate.providers.DataGenContext;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateRecipeProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.entry.BlockEntry;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullBiFunction;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullFunction;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullUnaryOperator;

public class BlockBuilder<O extends AbstractRegistrate<O>, T extends Block, P>
extends AbstractBuilder<O, Block, T, P, BlockBuilder<O, T, P>> {
    private final NonNullFunction<BlockBehaviour.Properties, T> factory;
    private NonNullSupplier<BlockBehaviour.Properties> initialProperties;
    private NonNullFunction<BlockBehaviour.Properties, BlockBehaviour.Properties> propertiesCallback = NonNullUnaryOperator.identity();
    private List<Supplier<Supplier<RenderType>>> renderLayers = new ArrayList<Supplier<Supplier<RenderType>>>(1);
    @Nullable
    private NonNullSupplier<Supplier<BlockColor>> colorHandler;

    public static <O extends AbstractRegistrate<O>, T extends Block, P> BlockBuilder<O, T, P> create(O owner, P parent, String name, BuilderCallback<O> callback, NonNullFunction<BlockBehaviour.Properties, T> factory, Material material) {
        return new BlockBuilder<O, T, P>(owner, parent, name, callback, factory, () -> BlockBehaviour.Properties.m_60939_((Material)material)).defaultBlockstate().defaultLoot().defaultLang();
    }

    protected BlockBuilder(O owner, P parent, String name, BuilderCallback<O> callback, NonNullFunction<BlockBehaviour.Properties, T> factory, NonNullSupplier<BlockBehaviour.Properties> initialProperties) {
        super(owner, parent, name, callback, Registry.f_122901_);
        this.factory = factory;
        this.initialProperties = initialProperties;
    }

    public BlockBuilder<O, T, P> properties(NonNullUnaryOperator<BlockBehaviour.Properties> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public BlockBuilder<O, T, P> initialProperties(Material material) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60939_((Material)material);
        return this;
    }

    public BlockBuilder<O, T, P> initialProperties(Material material, DyeColor color) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60941_((Material)material, (DyeColor)color);
        return this;
    }

    public BlockBuilder<O, T, P> initialProperties(Material material, MaterialColor color) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color);
        return this;
    }

    public BlockBuilder<O, T, P> initialProperties(NonNullSupplier<? extends Block> block) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get()));
        return this;
    }

    public BlockBuilder<O, T, P> initialProperties(Material material, NonNullFunction<BlockState, MaterialColor> materialColorFactory) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60947_((Material)material, (Function)materialColorFactory);
        return this;
    }

    public BlockBuilder<O, T, P> addLayer(Supplier<Supplier<RenderType>> layer) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> BlockBuilder.lambda$addLayer$6((Supplier)layer));
        if (this.renderLayers.isEmpty()) {
            this.onRegister(this::registerLayers);
        }
        this.renderLayers.add(layer);
        return this;
    }

    protected void registerLayers(T entry) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, $ -> {
            if (this.renderLayers.size() == 1) {
                RenderType layer = this.renderLayers.get(0).get().get();
                ItemBlockRenderTypes.setRenderLayer((Block)entry, (RenderType)layer);
            } else if (this.renderLayers.size() > 1) {
                Set layers = this.renderLayers.stream().map(s -> (RenderType)((Supplier)s.get()).get()).collect(Collectors.toSet());
                ItemBlockRenderTypes.setRenderLayer((Block)entry, layers::contains);
            }
        }));
    }

    public BlockBuilder<O, T, P> simpleItem() {
        return (BlockBuilder)this.item().build();
    }

    public ItemBuilder<O, BlockItem, BlockBuilder<O, T, P>> item() {
        return this.item(BlockItem::new);
    }

    public <I extends BlockItem> ItemBuilder<O, I, BlockBuilder<O, T, P>> item(NonNullBiFunction<? super T, Item.Properties, ? extends I> factory) {
        return ((ItemBuilder)((AbstractRegistrate)this.getOwner()).item((BlockBuilder)this, this.getName(), p -> (BlockItem)factory.apply((T)this.getEntry(), (Item.Properties)p)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model((ctx, prov) -> {
            Optional<String> model = ((AbstractRegistrate)this.getOwner()).getDataProvider(ProviderType.BLOCKSTATE).flatMap(p -> p.getExistingVariantBuilder((Block)this.getEntry())).map(b -> (BlockStateProvider.ConfiguredModelList)b.getModels().get(b.partialState())).map(BlockStateProvider.ConfiguredModelList::toJSON).filter(JsonElement::isJsonObject).map(j -> j.getAsJsonObject().get("model")).map(JsonElement::getAsString);
            if (model.isPresent()) {
                prov.withExistingParent(ctx.getName(), model.get());
            } else {
                prov.blockItem(this.asSupplier());
            }
        });
    }

    public <BE extends BlockEntity> BlockBuilder<O, T, P> simpleBlockEntity(BlockEntityBuilder.BlockEntityFactory<BE> factory) {
        return (BlockBuilder)this.blockEntity(factory).build();
    }

    public <BE extends BlockEntity> BlockEntityBuilder<O, BE, BlockBuilder<O, T, P>> blockEntity(BlockEntityBuilder.BlockEntityFactory<BE> factory) {
        return ((AbstractRegistrate)this.getOwner()).blockEntity((BlockBuilder)this, this.getName(), factory).validBlock(this.asSupplier());
    }

    public BlockBuilder<O, T, P> color(NonNullSupplier<Supplier<BlockColor>> colorHandler) {
        if (this.colorHandler == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerBlockColor);
        }
        this.colorHandler = colorHandler;
        return this;
    }

    protected void registerBlockColor() {
        OneTimeEventReceiver.addModListener(ColorHandlerEvent.Block.class, e -> {
            NonNullSupplier<Supplier<BlockColor>> colorHandler = this.colorHandler;
            if (colorHandler != null) {
                e.getBlockColors().m_92589_(colorHandler.get().get(), new Block[]{(Block)this.getEntry()});
            }
        });
    }

    public BlockBuilder<O, T, P> defaultBlockstate() {
        return this.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry()));
    }

    public BlockBuilder<O, T, P> blockstate(NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.BLOCKSTATE, cons);
    }

    public BlockBuilder<O, T, P> defaultLang() {
        return (BlockBuilder)this.lang(Block::m_7705_);
    }

    public BlockBuilder<O, T, P> lang(String name) {
        return (BlockBuilder)this.lang(Block::m_7705_, name);
    }

    public BlockBuilder<O, T, P> defaultLoot() {
        return this.loot(BlockLoot::m_124288_);
    }

    public BlockBuilder<O, T, P> loot(NonNullBiConsumer<RegistrateBlockLootTables, T> cons) {
        return (BlockBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.BLOCK, tb -> {
            if (!((Block)ctx.getEntry()).m_60589_().equals((Object)BuiltInLootTables.f_78712_)) {
                cons.accept((RegistrateBlockLootTables)tb, (Object)((Block)ctx.getEntry()));
            }
        }));
    }

    public BlockBuilder<O, T, P> recipe(NonNullBiConsumer<DataGenContext<Block, T>, RegistrateRecipeProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    @SafeVarargs
    public final BlockBuilder<O, T, P> tag(TagKey<Block> ... tags) {
        return (BlockBuilder)this.tag(ProviderType.BLOCK_TAGS, tags);
    }

    @Override
    protected T createEntry() {
        BlockBehaviour.Properties properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Block)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new BlockEntry<T>((AbstractRegistrate<?>)this.getOwner(), delegate);
    }

    @Override
    public BlockEntry<T> register() {
        return (BlockEntry)super.register();
    }

    public BlockBuilder<O, T, P> noCollission() {
        return this.properties(BlockBehaviour.Properties::m_60910_);
    }

    public BlockBuilder<O, T, P> noOcclusion() {
        return this.properties(BlockBehaviour.Properties::m_60955_);
    }

    public BlockBuilder<O, T, P> friction(float friction) {
        return this.properties(properties -> properties.m_60911_(friction));
    }

    public BlockBuilder<O, T, P> speedFactor(float speedFactor) {
        return this.properties(properties -> properties.m_60956_(speedFactor));
    }

    public BlockBuilder<O, T, P> jumpFactor(float jumpFactor) {
        return this.properties(properties -> properties.m_60967_(jumpFactor));
    }

    public BlockBuilder<O, T, P> sound(SoundType soundType) {
        return this.properties(properties -> properties.m_60918_(soundType));
    }

    public BlockBuilder<O, T, P> lightLevel(ToIntFunction<BlockState> lightLevelFunction) {
        return this.properties(properties -> properties.m_60953_(lightLevelFunction));
    }

    public BlockBuilder<O, T, P> strength(float destroyTime, float explosionResistance) {
        return this.properties(properties -> properties.m_60913_(destroyTime, explosionResistance));
    }

    public BlockBuilder<O, T, P> instabreak() {
        return this.properties(BlockBehaviour.Properties::m_60966_);
    }

    public BlockBuilder<O, T, P> strength(float strength) {
        return this.properties(properties -> properties.m_60978_(strength));
    }

    public BlockBuilder<O, T, P> randomTicks() {
        return this.properties(BlockBehaviour.Properties::m_60977_);
    }

    public BlockBuilder<O, T, P> dynamicShape() {
        return this.properties(BlockBehaviour.Properties::m_60988_);
    }

    @Deprecated(forRemoval=true)
    public BlockBuilder<O, T, P> noDrops() {
        return this.properties(BlockBehaviour.Properties::m_60993_);
    }

    @Deprecated
    public BlockBuilder<O, T, P> dropsLike(Block block) {
        return this.properties(properties -> properties.m_60916_(block));
    }

    public BlockBuilder<O, T, P> dropsLike(NonNullSupplier<? extends Block> block) {
        return this.properties(properties -> properties.lootFrom((Supplier)block));
    }

    public BlockBuilder<O, T, P> air() {
        return this.properties(BlockBehaviour.Properties::m_60996_);
    }

    public BlockBuilder<O, T, P> isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> extendedPositionPredicate) {
        return this.properties(properties -> properties.m_60922_(extendedPositionPredicate));
    }

    public BlockBuilder<O, T, P> isRedstoneConductor(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties(properties -> properties.m_60924_(positionPredicate));
    }

    public BlockBuilder<O, T, P> isSuffocating(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties(properties -> properties.m_60960_(positionPredicate));
    }

    public BlockBuilder<O, T, P> isViewBlocking(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties(properties -> properties.m_60971_(positionPredicate));
    }

    public BlockBuilder<O, T, P> hasPostProcess(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties(properties -> properties.m_60982_(positionPredicate));
    }

    public BlockBuilder<O, T, P> emissiveRendering(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties(properties -> properties.m_60991_(positionPredicate));
    }

    public BlockBuilder<O, T, P> requiresCorrectToolForDrops() {
        return this.properties(BlockBehaviour.Properties::m_60999_);
    }

    public BlockBuilder<O, T, P> color(MaterialColor materialColor) {
        return this.properties(properties -> properties.m_155949_(materialColor));
    }

    public BlockBuilder<O, T, P> destroyTime(float destroyTime) {
        return this.properties(properties -> properties.m_155954_(destroyTime));
    }

    public BlockBuilder<O, T, P> explosionResistance(float explosionResistance) {
        return this.properties(properties -> properties.m_155956_(explosionResistance));
    }

    private static /* synthetic */ void lambda$addLayer$6(Supplier layer) {
        Preconditions.checkArgument((boolean)RenderType.m_110506_().contains(((Supplier)layer.get()).get()), (Object)("Invalid block layer: " + layer));
    }
}

