/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.repack.com.tterrag.registrate.builders;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.builders.AbstractBuilder;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.entry.BlockEntityEntry;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullFunction;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;

public class BlockEntityBuilder<O extends AbstractRegistrate<O>, T extends BlockEntity, P>
extends AbstractBuilder<O, BlockEntityType<?>, BlockEntityType<T>, P, BlockEntityBuilder<O, T, P>> {
    private final BlockEntityFactory<T> factory;
    private final Set<NonNullSupplier<? extends Block>> validBlocks = new HashSet<NonNullSupplier<? extends Block>>();
    @Nullable
    private NonNullSupplier<NonNullFunction<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super T>>> renderer;

    public static <O extends AbstractRegistrate<O>, T extends BlockEntity, P> BlockEntityBuilder<O, T, P> create(O owner, P parent, String name, BuilderCallback<O> callback, BlockEntityFactory<T> factory) {
        return new BlockEntityBuilder<O, T, P>(owner, parent, name, callback, factory);
    }

    protected BlockEntityBuilder(O owner, P parent, String name, BuilderCallback<O> callback, BlockEntityFactory<T> factory) {
        super(owner, parent, name, callback, Registry.f_122907_);
        this.factory = factory;
    }

    public BlockEntityBuilder<O, T, P> validBlock(NonNullSupplier<? extends Block> block) {
        this.validBlocks.add(block);
        return this;
    }

    @SafeVarargs
    public final BlockEntityBuilder<O, T, P> validBlocks(NonNullSupplier<? extends Block> ... blocks) {
        Arrays.stream(blocks).forEach(this::validBlock);
        return this;
    }

    public BlockEntityBuilder<O, T, P> renderer(NonNullSupplier<NonNullFunction<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super T>>> renderer) {
        if (this.renderer == null) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::registerRenderer);
        }
        this.renderer = renderer;
        return this;
    }

    @SafeVarargs
    public final BlockEntityBuilder<O, T, P> tag(TagKey<BlockEntityType<?>> ... tags) {
        return (BlockEntityBuilder)this.tag(ProviderType.BLOCK_ENTITY_TAGS, tags);
    }

    protected void registerRenderer() {
        OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, $ -> {
            NonNullSupplier<NonNullFunction<BlockEntityRendererProvider.Context, BlockEntityRenderer<T>>> renderer = this.renderer;
            if (renderer != null) {
                BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)this.getEntry()), renderer.get()::apply);
            }
        });
    }

    @Override
    protected BlockEntityType<T> createEntry() {
        BlockEntityFactory factory = this.factory;
        NonNullSupplier supplier = this.asSupplier();
        return BlockEntityType.Builder.m_155273_((pos, state) -> factory.create((BlockEntityType)supplier.get(), pos, state), (Block[])((Block[])this.validBlocks.stream().map(NonNullSupplier::get).toArray(Block[]::new))).m_58966_(null);
    }

    @Override
    protected RegistryEntry<BlockEntityType<T>> createEntryWrapper(RegistryObject<BlockEntityType<T>> delegate) {
        return new BlockEntityEntry<T>((AbstractRegistrate<?>)this.getOwner(), delegate);
    }

    @Override
    public BlockEntityEntry<T> register() {
        return (BlockEntityEntry)super.register();
    }

    public static interface BlockEntityFactory<T extends BlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

