/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.repack.com.tterrag.registrate.builders;

import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.builders.AbstractBuilder;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public class EnchantmentBuilder<O extends AbstractRegistrate<O>, T extends Enchantment, P>
extends AbstractBuilder<O, Enchantment, T, P, EnchantmentBuilder<O, T, P>> {
    private Enchantment.Rarity rarity = Enchantment.Rarity.COMMON;
    private final EnchantmentCategory type;
    private EnumSet<EquipmentSlot> slots = EnumSet.noneOf(EquipmentSlot.class);
    private final EnchantmentFactory<T> factory;

    public static <O extends AbstractRegistrate<O>, T extends Enchantment, P> EnchantmentBuilder<O, T, P> create(O owner, P parent, String name, BuilderCallback<O> callback, EnchantmentCategory type, EnchantmentFactory<T> factory) {
        return new EnchantmentBuilder<O, T, P>(owner, parent, name, callback, type, factory).defaultLang();
    }

    protected EnchantmentBuilder(O owner, P parent, String name, BuilderCallback<O> callback, EnchantmentCategory type, EnchantmentFactory<T> factory) {
        super(owner, parent, name, callback, Registry.f_122902_);
        this.factory = factory;
        this.type = type;
    }

    public EnchantmentBuilder<O, T, P> rarity(Enchantment.Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnchantmentBuilder<O, T, P> addArmorSlots() {
        return this.addSlots(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
    }

    public EnchantmentBuilder<O, T, P> addSlots(EquipmentSlot ... slots) {
        this.slots.addAll(Arrays.asList(slots));
        return this;
    }

    public EnchantmentBuilder<O, T, P> defaultLang() {
        return (EnchantmentBuilder)this.lang(Enchantment::m_44704_);
    }

    public EnchantmentBuilder<O, T, P> lang(String name) {
        return (EnchantmentBuilder)this.lang(Enchantment::m_44704_, name);
    }

    @Override
    @NonnullType
    protected T createEntry() {
        return this.factory.create(this.rarity, this.type, this.slots.toArray(new EquipmentSlot[0]));
    }

    @FunctionalInterface
    public static interface EnchantmentFactory<T extends Enchantment> {
        public T create(Enchantment.Rarity var1, EnchantmentCategory var2, EquipmentSlot ... var3);
    }
}

