/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.block.tileentity.CookingPotTileEntity;
import io.github.wouink.furnish.item.util.TooltipHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CookingPot
extends Block {
    private static final VoxelShape POT = Block.func_208617_a((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)10.0, (double)14.0);
    private static final VoxelShape POT_Z = Block.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)10.0, (double)13.0);
    public static final BooleanProperty Z_AXIS = BooleanProperty.func_177716_a((String)"z_axis");

    public CookingPot(AbstractBlock.Properties p) {
        super(p.func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)Z_AXIS, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{Z_AXIS});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)Z_AXIS, (Comparable)Boolean.valueOf(ctx.func_195992_f().func_176740_k() == Direction.Axis.Z));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return (Boolean)state.func_177229_b((Property)Z_AXIS) != false ? POT_Z : POT;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CookingPotTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        if (playerEntity.func_175149_v()) {
            return ActionResultType.CONSUME;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CookingPotTileEntity) {
            playerEntity.func_213829_a((INamedContainerProvider)((CookingPotTileEntity)tileEntity));
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity) {
        if (world.func_201670_d()) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CookingPotTileEntity) {
            ItemStack result;
            boolean popped = false;
            if (playerEntity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                ItemStack result2 = ((CookingPotTileEntity)tileEntity).pop();
                if (!result2.func_190926_b()) {
                    playerEntity.func_184611_a(Hand.MAIN_HAND, result2);
                    popped = true;
                }
            } else if (playerEntity.func_184586_b(Hand.MAIN_HAND).func_222117_E() && (result = ((CookingPotTileEntity)tileEntity).popSimilar(playerEntity.func_184586_b(Hand.MAIN_HAND))).func_190916_E() != playerEntity.func_184586_b(Hand.MAIN_HAND).func_190916_E()) {
                playerEntity.func_184611_a(Hand.MAIN_HAND, result);
                popped = true;
            }
            if (popped) {
                world.func_184133_a(playerEntity, pos, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_190948_a(stack, world, tooltip, flag);
        TooltipHelper.appendInventoryContent(stack, tooltip);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity playerEntity) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CookingPotTileEntity) {
            CookingPotTileEntity pot = (CookingPotTileEntity)tileEntity;
            if (!world.func_201670_d() && playerEntity.func_184812_l_() && !pot.func_191420_l()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                CompoundNBT nbt = pot.func_189515_b(new CompoundNBT());
                if (!nbt.isEmpty()) {
                    stack.func_77983_a("BlockEntityTag", (INBT)nbt);
                }
                if (pot.func_145818_k_()) {
                    stack.func_200302_a(pot.func_200201_e());
                }
                ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177952_p() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                item.func_174869_p();
                world.func_217376_c((Entity)item);
            } else {
                pot.func_184281_d(playerEntity);
            }
        }
        super.func_176208_a(world, pos, state, playerEntity);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileEntity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileEntity instanceof CookingPotTileEntity) {
            CookingPotTileEntity pot = (CookingPotTileEntity)tileEntity;
            builder = builder.func_216017_a(ShulkerBoxBlock.field_220169_b, (lootCtx, stackConsumer) -> {
                for (int i = 0; i < pot.func_70302_i_(); ++i) {
                    stackConsumer.accept(pot.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(state, builder);
    }
}

