/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishData;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class Cymbal
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final IntegerProperty NOTE = FurnishBlocks.CustomProperties.NOTE;
    public static final BooleanProperty HIHAT = BooleanProperty.func_177716_a((String)"hihat");
    private static final VoxelShape CYMBAL_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0));
    private static final VoxelShape HIHAT_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));

    public Cymbal(AbstractBlock.Properties p) {
        super(p.func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)HIHAT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NOTE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NOTE, POWERED, HIHAT});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return (Boolean)state.func_177229_b((Property)HIHAT) != false ? HIHAT_SHAPE : CYMBAL_SHAPE;
    }

    private void playSound(BlockState state, World world, BlockPos pos) {
        float pitch = (float)Math.pow(2.0, (double)((Integer)state.func_177229_b((Property)NOTE) - 12) / 12.0);
        world.func_184133_a(null, pos, (Boolean)state.func_177229_b((Property)HIHAT) != false ? (SoundEvent)FurnishData.Sounds.Cymbal_Hihat.get() : (SoundEvent)FurnishData.Sounds.Cymbal.get(), SoundCategory.RECORDS, 3.0f, pitch);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        ActionResultType res = ActionResultType.FAIL;
        if (!world.func_201670_d()) {
            ItemStack stack = playerEntity.func_184586_b(hand);
            if (stack.func_77973_b() == this.func_199767_j()) {
                if (!((Boolean)state.func_177229_b((Property)HIHAT)).booleanValue()) {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HIHAT, (Comparable)Boolean.valueOf(true)), 3);
                    stack.func_190918_g(1);
                    playerEntity.func_184611_a(hand, stack);
                    res = ActionResultType.SUCCESS;
                } else {
                    res = ActionResultType.FAIL;
                }
            } else {
                int newNote = ForgeHooks.onNoteChange((World)world, (BlockPos)pos, (BlockState)state, (int)((Integer)state.func_177229_b((Property)NOTE)), (int)((Integer)((BlockState)state.func_235896_a_((Property)NOTE)).func_177229_b((Property)NOTE)));
                if (newNote == -1) {
                    res = ActionResultType.FAIL;
                } else {
                    state = (BlockState)state.func_206870_a((Property)NOTE, (Comparable)Integer.valueOf(newNote));
                    world.func_180501_a(pos, state, 3);
                    this.playSound(state, world, pos);
                    playerEntity.func_195066_a(Stats.field_188087_U);
                    res = ActionResultType.SUCCESS;
                }
            }
        }
        return res == ActionResultType.SUCCESS ? ActionResultType.func_233537_a_((boolean)world.func_201670_d()) : res;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity) {
        if (!world.func_201670_d() && !playerEntity.func_184812_l_()) {
            this.playSound(state, world, pos);
            playerEntity.func_195066_a(Stats.field_188086_T);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighbor, BlockPos neighborPos, boolean moving) {
        boolean flag = world.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((Property)POWERED)) {
            if (flag) {
                this.playSound(state, world, pos);
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }
}

