/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.setup.FurnishBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.RegistryObject;

public class Drum
extends Block {
    private final RegistryObject<SoundEvent> instrumentSound;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final IntegerProperty NOTE = FurnishBlocks.CustomProperties.NOTE;

    public Drum(AbstractBlock.Properties p, RegistryObject<SoundEvent> instrumentSound) {
        super(p);
        this.instrumentSound = instrumentSound;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NOTE, POWERED});
    }

    private void playSound(BlockState state, World world, BlockPos pos) {
        float pitch = (float)Math.pow(2.0, (double)((Integer)state.func_177229_b((Property)NOTE) - 12) / 12.0);
        world.func_184133_a(null, pos, (SoundEvent)this.instrumentSound.get(), SoundCategory.RECORDS, 3.0f, pitch);
    }

    private void playSound(World world, BlockPos pos, float volume, float pitch) {
        world.func_184133_a(null, pos, (SoundEvent)this.instrumentSound.get(), SoundCategory.RECORDS, 3.0f * volume, pitch);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        int newNote = ForgeHooks.onNoteChange((World)world, (BlockPos)pos, (BlockState)state, (int)((Integer)state.func_177229_b((Property)NOTE)), (int)((Integer)((BlockState)state.func_235896_a_((Property)NOTE)).func_177229_b((Property)NOTE)));
        if (newNote == -1) {
            return ActionResultType.FAIL;
        }
        state = (BlockState)state.func_206870_a((Property)NOTE, (Comparable)Integer.valueOf(newNote));
        world.func_180501_a(pos, state, 3);
        this.playSound(state, world, pos);
        playerEntity.func_195066_a(Stats.field_188087_U);
        return ActionResultType.CONSUME;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity) {
        if (!world.func_201670_d() && !playerEntity.func_184812_l_()) {
            this.playSound(state, world, pos);
            playerEntity.func_195066_a(Stats.field_188086_T);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighbor, BlockPos neighborPos, boolean moving) {
        boolean flag = world.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((Property)POWERED)) {
            if (flag) {
                this.playSound(state, world, pos);
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        float entitySize = entity.func_213311_cf() * entity.func_213302_cg();
        this.playSound(world, pos, Math.min(entitySize, 3.0f), distance);
    }

    public void func_176216_a(IBlockReader reader, Entity entity) {
        if (entity.func_226272_bl_()) {
            super.func_176216_a(reader, entity);
        } else {
            Drum.bounceUp(entity);
        }
    }

    private static void bounceUp(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(vector3d.field_72450_a, -vector3d.field_72448_b * (double)0.66f * d0, vector3d.field_72449_c);
        }
    }
}

