/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.block.SimpleFurniture;
import io.github.wouink.furnish.block.tileentity.FurnitureTileEntity;
import io.github.wouink.furnish.block.util.IFurnitureWithSound;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class InventoryFurniture
extends SimpleFurniture
implements ISidedInventoryProvider,
IFurnitureWithSound {
    private final RegistryObject<SoundEvent> openSound;
    private final RegistryObject<SoundEvent> closeSound;

    public InventoryFurniture(AbstractBlock.Properties p, RegistryObject<SoundEvent> openSound, RegistryObject<SoundEvent> closeSound) {
        super(p);
        this.openSound = openSound;
        this.closeSound = closeSound;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FurnitureTileEntity();
    }

    public ISidedInventory func_219966_a(BlockState state, IWorld world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ISidedInventoryProvider) {
            return (ISidedInventory)tileEntity;
        }
        return null;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof FurnitureTileEntity) {
            playerEntity.func_213829_a((INamedContainerProvider)tileEntity);
        }
        return ActionResultType.CONSUME;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean moving) {
        TileEntity tileEntity;
        if (state.func_177230_c() != newState.func_177230_c() && (tileEntity = world.func_175625_s(pos)) instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
        super.func_196243_a(state, world, pos, newState, moving);
    }

    @Override
    public SoundEvent getOpenSound() {
        return (SoundEvent)this.openSound.get();
    }

    @Override
    public SoundEvent getCloseSound() {
        return (SoundEvent)this.closeSound.get();
    }
}

