/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.block.tileentity.MailboxTileEntity;
import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.setup.FurnishData;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class Mailbox
extends HorizontalBlock {
    public static ArrayList<Mailbox> All_Mailboxes = new ArrayList();
    public static final VoxelShape[] MAILBOX_SHAPE = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)12.0, (double)13.0));
    public static final BooleanProperty ON_FENCE = BooleanProperty.func_177716_a((String)"on_fence");
    public static final BooleanProperty HAS_MAIL = BooleanProperty.func_177716_a((String)"has_mail");

    public Mailbox(AbstractBlock.Properties p) {
        super(p);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)ON_FENCE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_MAIL, (Comparable)Boolean.valueOf(false)));
        All_Mailboxes.add(this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D, ON_FENCE, HAS_MAIL});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)ctx.func_195992_f().func_176734_d());
        if (ctx.func_195991_k().func_180495_p(ctx.func_195995_a().func_177977_b()).func_177230_c() instanceof FenceBlock) {
            state = (BlockState)state.func_206870_a((Property)ON_FENCE, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        TileEntity tileEntity;
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.mailbox.ownership_info"), true);
        }
        if (stack.func_82837_s() && (tileEntity = world.func_175625_s(pos)) instanceof MailboxTileEntity) {
            ((MailboxTileEntity)tileEntity).func_213903_a(stack.func_200301_q());
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        return MAILBOX_SHAPE[((Direction)state.func_177229_b((Property)field_185512_D)).ordinal() - 2];
    }

    private boolean updateMailbox(BlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof MailboxTileEntity) {
            boolean mail = ((MailboxTileEntity)tileEntity).hasMail();
            if ((Boolean)state.func_177229_b((Property)HAS_MAIL) != mail) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HAS_MAIL, (Comparable)Boolean.valueOf(mail)), 3);
                tileEntity.func_70296_d();
                world.func_184133_a(null, pos, (SoundEvent)FurnishData.Sounds.Mailbox_Update.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity;
        ActionResultType res = ActionResultType.FAIL;
        if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof MailboxTileEntity) {
            MailboxTileEntity mailbox = (MailboxTileEntity)tileEntity;
            if (!mailbox.hasOwner()) {
                mailbox.setOwner(playerEntity);
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.mailbox.set_owner"), true);
                res = ActionResultType.SUCCESS;
            } else if (mailbox.isOwner(playerEntity)) {
                mailbox.updateDisplayName(playerEntity);
                if (!this.updateMailbox(state, world, pos)) {
                    playerEntity.func_213829_a((INamedContainerProvider)mailbox);
                }
                res = ActionResultType.SUCCESS;
            } else if (playerEntity.func_184586_b(hand).func_190926_b()) {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.mailbox.no_permission"), true);
                res = ActionResultType.FAIL;
            } else if (mailbox.isFull()) {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.mailbox.full"), true);
                res = ActionResultType.FAIL;
            } else {
                ItemStack result = mailbox.addMail(playerEntity.func_184586_b(hand));
                playerEntity.func_184611_a(hand, result);
                this.updateMailbox(state, world, pos);
                if (result.func_190926_b()) {
                    ITextComponent ownerName = mailbox.getOwnerDisplayName();
                    if (ownerName != null) {
                        playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.mailbox.mail_delivered_to", new Object[]{ownerName}), true);
                    } else {
                        playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.mailbox.mail_delivered"), true);
                    }
                    res = ActionResultType.SUCCESS;
                } else {
                    playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.mailbox.invalid_mail"), true);
                    res = ActionResultType.FAIL;
                }
            }
        }
        return res == ActionResultType.SUCCESS ? ActionResultType.func_233537_a_((boolean)world.func_201670_d()) : res;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MailboxTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean moving) {
        TileEntity tileEntity;
        if (state.func_177230_c() != newState.func_177230_c() && (tileEntity = world.func_175625_s(pos)) instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
        super.func_196243_a(state, world, pos, newState, moving);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof MailboxTileEntity) {
            if (((MailboxTileEntity)tileEntity).isOwner(player)) {
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.mailbox.no_permission"), true);
        }
        return false;
    }
}

