/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.block.container.CookingPotContainer;
import io.github.wouink.furnish.block.tileentity.PlateTileEntity;
import io.github.wouink.furnish.block.util.ISpecialItemProperties;
import io.github.wouink.furnish.setup.FurnishItems;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class Plate
extends HorizontalBlock
implements ISpecialItemProperties {
    public static final VoxelShape PLATE_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final ResourceLocation WHITELIST = CookingPotContainer.COOKING_POT_TAG;

    public Plate(AbstractBlock.Properties p) {
        super(p.func_226896_b_());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)ctx.func_195992_f().func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return PLATE_SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        ActionResultType resultType = ActionResultType.FAIL;
        if (!world.func_201670_d() && (playerEntity.func_184586_b(hand).func_190926_b() || playerEntity.func_184586_b(hand).func_222117_E() || playerEntity.func_184586_b(hand).func_77973_b().getTags().contains(WHITELIST)) && (tileEntity = world.func_175625_s(pos)) instanceof PlateTileEntity) {
            playerEntity.func_184611_a(hand, ((PlateTileEntity)tileEntity).swap(playerEntity.func_184586_b(hand)));
            resultType = ActionResultType.SUCCESS;
        }
        return resultType == ActionResultType.SUCCESS ? ActionResultType.func_233537_a_((boolean)world.func_201670_d()) : resultType;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PlateTileEntity();
    }

    @Override
    public Item.Properties getProperties() {
        Rarity rarity = this.getRegistryName().func_110623_a().startsWith("rare_") ? Rarity.RARE : Rarity.COMMON;
        return new Item.Properties().func_200916_a(FurnishItems.Furnish_ItemGroup).func_200917_a(16).func_208103_a(rarity);
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        ItemStack stack;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof PlateTileEntity && !(stack = ((PlateTileEntity)tileEntity).getHeldItem().func_77946_l()).func_190926_b()) {
            stack.func_190920_e(1);
            return stack;
        }
        return super.func_185473_a(world, pos, state);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean moving) {
        ItemStack stack;
        super.func_196243_a(state, world, pos, newState, moving);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof PlateTileEntity && !(stack = ((PlateTileEntity)tileEntity).getHeldItem()).func_190926_b()) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        }
    }
}

