/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.block.util.PlacementHelper;
import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.setup.FurnishBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class Shutter
extends HorizontalBlock {
    private static final VoxelShape[] SHUTTER_CLOSED = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0));
    private static final VoxelShape[] SHUTTER_HALF_OPENED = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape[] SHUTTER_HALF_OPENED_R = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));
    private static final VoxelShape[] SHUTTER_OPENED = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)30.0));
    private static final VoxelShape[] SHUTTER_OPENED_R = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)0.0, (double)0.0, (double)-14.0, (double)2.0, (double)16.0, (double)2.0));
    private static final VoxelShape[] INTERACT_HALF = VoxelShapeHelper.getMergedShapes(SHUTTER_CLOSED, SHUTTER_HALF_OPENED);
    private static final VoxelShape[] INTERACT_HALF_R = VoxelShapeHelper.getMergedShapes(SHUTTER_CLOSED, SHUTTER_HALF_OPENED_R);
    private static final VoxelShape[] INTERACT_OPEN = VoxelShapeHelper.getMergedShapes(SHUTTER_CLOSED, SHUTTER_OPENED);
    private static final VoxelShape[] INTERACT_OPEN_R = VoxelShapeHelper.getMergedShapes(SHUTTER_CLOSED, SHUTTER_OPENED_R);
    public static final BooleanProperty RIGHT = FurnishBlocks.CustomProperties.RIGHT;
    public static final EnumProperty<State> STATE = EnumProperty.func_177709_a((String)"state", State.class);

    public Shutter(AbstractBlock.Properties p) {
        super(p.func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a(STATE, (Comparable)((Object)State.CLOSED))).func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D, STATE, RIGHT});
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)ctx.func_195992_f().func_176734_d())).func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(PlacementHelper.placeRight(ctx)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.func_180501_a(pos, (BlockState)state.func_235896_a_(STATE), 3)) {
            world.func_184133_a(playerEntity, pos, SoundEvents.field_187879_gP, SoundCategory.BLOCKS, 1.0f, 1.0f);
            boolean rightProp = (Boolean)world.func_180495_p(pos).func_177229_b((Property)RIGHT);
            BlockPos scan = pos.func_177977_b();
            while (world.func_180495_p(scan).func_177230_c() == this && (Boolean)world.func_180495_p(scan).func_177229_b((Property)RIGHT) == rightProp) {
                world.func_180501_a(scan, world.func_180495_p(pos), 3);
                scan = scan.func_177977_b();
            }
            scan = pos.func_177984_a();
            while (world.func_180495_p(scan).func_177230_c() == this && (Boolean)world.func_180495_p(scan).func_177229_b((Property)RIGHT) == rightProp) {
                world.func_180501_a(scan, world.func_180495_p(pos), 3);
                scan = scan.func_177984_a();
            }
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        int index = ((Direction)state.func_177229_b((Property)field_185512_D)).ordinal() - 2;
        if (state.func_177229_b(STATE) == State.HALF_OPEN) {
            return (Boolean)state.func_177229_b((Property)RIGHT) != false ? INTERACT_HALF_R[index] : INTERACT_HALF[index];
        }
        if (state.func_177229_b(STATE) == State.OPEN) {
            return (Boolean)state.func_177229_b((Property)RIGHT) != false ? INTERACT_OPEN_R[index] : INTERACT_OPEN[index];
        }
        return SHUTTER_CLOSED[index];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        int index = ((Direction)state.func_177229_b((Property)field_185512_D)).ordinal() - 2;
        if (state.func_177229_b(STATE) == State.HALF_OPEN) {
            return (Boolean)state.func_177229_b((Property)RIGHT) != false ? SHUTTER_HALF_OPENED_R[index] : SHUTTER_HALF_OPENED[index];
        }
        if (state.func_177229_b(STATE) == State.OPEN) {
            return (Boolean)state.func_177229_b((Property)RIGHT) != false ? SHUTTER_OPENED_R[index] : SHUTTER_OPENED[index];
        }
        return SHUTTER_CLOSED[index];
    }

    public VoxelShape func_230335_e_(BlockState p_230335_1_, IBlockReader p_230335_2_, BlockPos p_230335_3_) {
        return VoxelShapes.func_197880_a();
    }

    public static enum State implements IStringSerializable
    {
        CLOSED("closed"),
        HALF_OPEN("half_open"),
        OPEN("open");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

