/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.entity.SeatEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Sofa
extends HorizontalBlock {
    private static final VoxelShape[] SEAT = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0));
    private static final VoxelShape[] SITTING = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)13.0, (double)6.0, (double)16.0));
    private static final VoxelShape[] REST_L = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)15.0, (double)10.0, (double)3.0));
    private static final VoxelShape[] REST_R = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)4.0, (double)0.0, (double)13.0, (double)15.0, (double)10.0, (double)16.0));
    private static final VoxelShape[] SEAT_L = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0));
    private static final VoxelShape[] SEAT_R = VoxelShapeHelper.getRotatedShapes(Block.func_208617_a((double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape[] MIDDLE_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING);
    private static final VoxelShape[] ARMCHAIR_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING, REST_L, REST_R);
    private static final VoxelShape[] RIGHT_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING, REST_L);
    private static final VoxelShape[] LEFT_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING, REST_R);
    private static final VoxelShape[] RIGHT_CORNER_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING, SEAT_L);
    private static final VoxelShape[] LEFT_CORNER_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING, SEAT_R);
    public static final EnumProperty<SofaType> SOFA_TYPE = EnumProperty.func_177709_a((String)"type", SofaType.class);

    public Sofa(AbstractBlock.Properties p) {
        super(p.func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a(SOFA_TYPE, (Comparable)((Object)SofaType.ARMCHAIR)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D, SOFA_TYPE});
    }

    private BlockState setBlockState(BlockState state, Direction dir, BlockPos pos, IWorld world) {
        BlockState front;
        boolean right;
        BlockState leftState = world.func_180495_p(pos.func_177972_a(dir.func_176735_f()));
        BlockState rightState = world.func_180495_p(pos.func_177972_a(dir.func_176746_e()));
        boolean left = leftState.func_177230_c() instanceof Sofa && (leftState.func_177229_b((Property)field_185512_D) == state.func_177229_b((Property)field_185512_D) || leftState.func_177229_b(SOFA_TYPE) == SofaType.CORNER_RIGHT);
        boolean bl = right = rightState.func_177230_c() instanceof Sofa && (rightState.func_177229_b((Property)field_185512_D) == state.func_177229_b((Property)field_185512_D) || rightState.func_177229_b(SOFA_TYPE) == SofaType.CORNER_LEFT);
        state = left && right ? (BlockState)state.func_206870_a(SOFA_TYPE, (Comparable)((Object)SofaType.MIDDLE)) : (left ? ((front = world.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D)))).func_177230_c() instanceof Sofa && front.func_177229_b((Property)field_185512_D) == ((Direction)state.func_177229_b((Property)field_185512_D)).func_176746_e() ? (BlockState)state.func_206870_a(SOFA_TYPE, (Comparable)((Object)SofaType.CORNER_RIGHT)) : (BlockState)state.func_206870_a(SOFA_TYPE, (Comparable)((Object)SofaType.RIGHT))) : (right ? ((front = world.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D)))).func_177230_c() instanceof Sofa && front.func_177229_b((Property)field_185512_D) == ((Direction)state.func_177229_b((Property)field_185512_D)).func_176735_f() ? (BlockState)state.func_206870_a(SOFA_TYPE, (Comparable)((Object)SofaType.CORNER_LEFT)) : (BlockState)state.func_206870_a(SOFA_TYPE, (Comparable)((Object)SofaType.LEFT))) : (BlockState)state.func_206870_a(SOFA_TYPE, (Comparable)((Object)SofaType.ARMCHAIR))));
        return state;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        int index = ((Direction)state.func_177229_b((Property)field_185512_D)).ordinal() - 2;
        VoxelShape ret = ARMCHAIR_SHAPE[index];
        switch (((SofaType)((Object)state.func_177229_b(SOFA_TYPE))).ordinal()) {
            case 1: {
                ret = LEFT_SHAPE[index];
                break;
            }
            case 2: {
                ret = RIGHT_SHAPE[index];
                break;
            }
            case 3: {
                ret = MIDDLE_SHAPE[index];
                break;
            }
            case 4: {
                ret = LEFT_CORNER_SHAPE[index];
                break;
            }
            case 5: {
                ret = RIGHT_CORNER_SHAPE[index];
                break;
            }
        }
        return ret;
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState fromState, IWorld world, BlockPos pos, BlockPos formPos) {
        return this.setBlockState(state, ((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d(), pos, world);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)ctx.func_195992_f().func_176734_d());
        return this.setBlockState(state, ctx.func_195992_f(), ctx.func_195995_a(), (IWorld)ctx.func_195991_k());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        return SeatEntity.create(world, pos, 0.2, playerEntity);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float dist) {
        super.func_180658_a(world, pos, entity, dist * 0.5f);
    }

    public void func_176216_a(IBlockReader reader, Entity entity) {
        if (entity.func_226272_bl_()) {
            super.func_176216_a(reader, entity);
        } else {
            Sofa.bounceUp(entity);
        }
    }

    private static void bounceUp(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.func_213293_j(vector3d.field_72450_a, -vector3d.field_72448_b * (double)0.66f * d0, vector3d.field_72449_c);
        }
    }

    public static enum SofaType implements IStringSerializable
    {
        ARMCHAIR("armchair"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String name;

        private SofaType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

