/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block.container;

import com.google.common.collect.Lists;
import io.github.wouink.furnish.recipe.FurnitureRecipe;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishData;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class FurnitureWorkbenchContainer
extends Container {
    private final IWorldPosCallable worldPosCallable;
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.func_221492_a();
    private final World world;
    private List<FurnitureRecipe> recipes = Lists.newArrayList();
    private ItemStack itemStackInput = ItemStack.field_190927_a;
    private long lastOnTake;
    final Slot inputInventorySlot;
    final Slot outputInventorySlot;
    private Runnable inventoryUpdateListener = () -> {};
    public final IInventory inputInventory = new Inventory(1){

        public void func_70296_d() {
            super.func_70296_d();
            FurnitureWorkbenchContainer.this.func_75130_a((IInventory)this);
            FurnitureWorkbenchContainer.this.inventoryUpdateListener.run();
        }
    };
    private final CraftResultInventory inventory = new CraftResultInventory();

    public FurnitureWorkbenchContainer(int windowId, PlayerInventory playerInventory) {
        this(windowId, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public FurnitureWorkbenchContainer(int windowId, PlayerInventory playerInventory, final IWorldPosCallable worldPos) {
        super((ContainerType)FurnishData.Containers.Furniture_Workbench.get(), windowId);
        this.worldPosCallable = worldPos;
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.inputInventorySlot = this.func_75146_a(new Slot(this.inputInventory, 0, 20, 33));
        this.outputInventorySlot = this.func_75146_a(new Slot((IInventory)this.inventory, 1, 143, 33){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                ItemStack itemStack = FurnitureWorkbenchContainer.this.inputInventorySlot.func_75209_a(1);
                if (!itemStack.func_190926_b()) {
                    FurnitureWorkbenchContainer.this.updateRecipeResultSlot();
                }
                stack.func_77973_b().func_77622_d(stack, thePlayer.field_70170_p, thePlayer);
                worldPos.func_221486_a((world, pos) -> {
                    long l = world.func_82737_E();
                    if (FurnitureWorkbenchContainer.this.lastOnTake != l) {
                        world.func_184133_a(null, pos, SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        FurnitureWorkbenchContainer.this.lastOnTake = l;
                    }
                });
                return super.func_190901_a(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
        this.func_216958_a(this.selectedRecipe);
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.func_221495_b();
    }

    public List<FurnitureRecipe> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemsInInputSlot() {
        return this.inputInventorySlot.func_75216_d() && !this.recipes.isEmpty();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return FurnitureWorkbenchContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)FurnishBlocks.Furniture_Workbench);
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipe.func_221494_a(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    public boolean isValidRecipeIndex(int n) {
        return n >= 0 && n < this.getRecipeListSize();
    }

    public void func_75130_a(IInventory inv) {
        ItemStack itemStack = this.inputInventorySlot.func_75211_c();
        if (itemStack.func_77973_b() != this.itemStackInput.func_77973_b()) {
            this.itemStackInput = itemStack.func_77946_l();
            this.updateAvailableRecipes(inv, itemStack);
        }
    }

    private void updateAvailableRecipes(IInventory inv, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.func_221494_a(-1);
        this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.recipes = this.world.func_199532_z().func_215370_b(FurnishData.Furniture_Recipe, inv, this.world);
        }
    }

    public void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipe.func_221495_b())) {
            FurnitureRecipe recipe = this.recipes.get(this.selectedRecipe.func_221495_b());
            this.outputInventorySlot.func_75215_d(recipe.func_77572_b(this.inputInventory));
        } else {
            this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public ContainerType<?> func_216957_a() {
        return (ContainerType)FurnishData.Containers.Furniture_Workbench.get();
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.inventory && super.func_94530_a(stack, slot);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack1 = slot.func_75211_c();
            Item item = itemStack1.func_77973_b();
            itemStack = itemStack1.func_77946_l();
            if (index == 1) {
                item.func_77622_d(itemStack1, playerIn.field_70170_p, playerIn);
                if (!this.func_75135_a(itemStack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemStack1, itemStack);
            } else if (index == 0 ? !this.func_75135_a(itemStack1, 2, 38, false) : (this.world.func_199532_z().func_215371_a(FurnishData.Furniture_Recipe, (IInventory)new Inventory(new ItemStack[]{itemStack1}), this.world).isPresent() ? !this.func_75135_a(itemStack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.func_75135_a(itemStack1, 29, 38, false) : index >= 29 && index < 38 && !this.func_75135_a(itemStack1, 2, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (itemStack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (itemStack1.func_190916_E() == itemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemStack1);
            this.func_75142_b();
        }
        return itemStack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_70304_b(1);
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerIn, playerIn.field_70170_p, this.inputInventory));
    }
}

