/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block.tileentity;

import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.block.container.MailboxContainer;
import io.github.wouink.furnish.item.Letter;
import io.github.wouink.furnish.setup.FurnishData;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class MailboxTileEntity
extends LockableLootTileEntity {
    public static final int SIZE = 18;
    private static final ResourceLocation MAIL_TAG = new ResourceLocation("furnish", "mail");
    protected NonNullList<ItemStack> inventory;
    private String owner;
    private String ownerDisplayName;

    protected MailboxTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public MailboxTileEntity() {
        super((TileEntityType)FurnishData.TileEntities.TE_Mailbox.get());
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    protected void func_199721_a(NonNullList<ItemStack> newInventory) {
        this.inventory = newInventory;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent(String.format("block.%s.%s", "furnish", this.func_195044_w().func_177230_c().getRegistryName().func_110623_a()));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        nbt.func_74778_a("Owner", this.owner == null ? "" : this.owner);
        nbt.func_74778_a("OwnerDisplayName", this.ownerDisplayName == null ? "" : this.ownerDisplayName);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        this.owner = nbt.func_74779_i("Owner");
        this.ownerDisplayName = nbt.func_74779_i("OwnerDisplayName");
        if (this.ownerDisplayName.equals("")) {
            this.ownerDisplayName = null;
        }
    }

    protected Container func_213906_a(int syncId, PlayerInventory playerInventory) {
        return new MailboxContainer(syncId, playerInventory, (IInventory)this);
    }

    public int func_70302_i_() {
        return 18;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public void updateDisplayName(PlayerEntity playerEntity) {
        String playerName;
        if (this.isOwner(playerEntity) && !this.ownerDisplayName.equals(playerName = playerEntity.func_146103_bH().getName())) {
            this.ownerDisplayName = playerName;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void setOwner(PlayerEntity playerEntity) {
        this.owner = playerEntity.func_189512_bd();
        this.updateDisplayName(playerEntity);
    }

    public UUID getOwner() {
        return UUID.fromString(this.owner);
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public boolean isOwner(PlayerEntity playerEntity) {
        return this.hasOwner() && playerEntity.func_189512_bd().equals(this.owner);
    }

    public boolean hasMail() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean isFull() {
        return !this.inventory.contains((Object)ItemStack.field_190927_a);
    }

    public ItemStack addMail(ItemStack stack) {
        int slot;
        if (((Boolean)Furnish.CONFIG.restrictMailboxItems.get()).booleanValue() && !stack.func_77973_b().getTags().contains(MAIL_TAG)) {
            return stack;
        }
        if (stack.func_77973_b() instanceof Letter) {
            Letter.signLetter(stack, "Anonymous Player");
        }
        if ((slot = this.getFreeSlot()) < this.func_70302_i_()) {
            PlayerEntity mailboxOwner;
            ItemStack result = (ItemStack)this.inventory.set(slot, (Object)stack);
            if (result.func_190926_b() && (mailboxOwner = this.field_145850_b.func_217371_b(this.getOwner())) != null) {
                if (this.func_145818_k_()) {
                    mailboxOwner.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.mailbox.new_mail_loc", new Object[]{this.func_200201_e()}), true);
                } else {
                    mailboxOwner.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.mailbox.new_mail"), true);
                }
            }
            return result;
        }
        return stack;
    }

    public ITextComponent getOwnerDisplayName() {
        return !this.hasOwner() || this.ownerDisplayName.isEmpty() ? null : new StringTextComponent(this.ownerDisplayName);
    }

    private int getFreeSlot() {
        int slot;
        for (slot = 0; slot < this.inventory.size() && !((ItemStack)this.inventory.get(slot)).func_190926_b(); ++slot) {
        }
        return slot;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1234, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState state = this.func_195044_w();
        this.func_230337_a_(state, pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }
}

