/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.wouink.furnish.block.container.FurnitureWorkbenchContainer;
import io.github.wouink.furnish.recipe.FurnitureRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class FurnitureWorkbenchScreen
extends ContainerScreen<FurnitureWorkbenchContainer> {
    private static final ResourceLocation Background_Texture = new ResourceLocation("furnish", "textures/gui/furniture_workbench.png");
    private float sliderProgress;
    private boolean clickedOnScroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;

    public FurnitureWorkbenchScreen(FurnitureWorkbenchContainer container, PlayerInventory inv, ITextComponent title) {
        super((Container)container, inv, title);
        container.setInventoryUpdateListener(this::onInventoryUpdate);
        --this.field_238743_q_;
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.func_230459_a_(ms, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack ms, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        this.func_230446_a_(ms);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(Background_Texture);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(ms, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = (int)(41.0f * this.sliderProgress);
        int l = this.field_147003_i + 52;
        int i1 = this.field_147009_r + 14;
        int j1 = this.recipeIndexOffset + 12;
        this.renderButtons(ms, p_230450_3_, p_230450_4_, l, i1, j1);
        this.drawRecipesItems(l, i1, j1);
    }

    protected void func_230459_a_(MatrixStack ms, int mouseX, int mouseY) {
        super.func_230459_a_(ms, mouseX, mouseY);
        if (this.hasItemsInInputSlot) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.recipeIndexOffset + 12;
            List<FurnitureRecipe> list = ((FurnitureWorkbenchContainer)this.field_147002_h).getRecipeList();
            for (int l = this.recipeIndexOffset; l < k && l < ((FurnitureWorkbenchContainer)this.field_147002_h).getRecipeListSize(); ++l) {
                int i1 = l - this.recipeIndexOffset;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (mouseX < j1 || mouseX >= j1 + 16 || mouseY < k1 || mouseY >= k1 + 18) continue;
                this.func_230457_a_(ms, list.get(l).func_77571_b(), mouseX, mouseY);
            }
        }
    }

    private void renderButtons(MatrixStack p_238853_1_, int p_238853_2_, int p_238853_3_, int p_238853_4_, int p_238853_5_, int p_238853_6_) {
        for (int i = this.recipeIndexOffset; i < p_238853_6_ && i < ((FurnitureWorkbenchContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = p_238853_4_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_238853_5_ + l * 18 + 2;
            int j1 = this.field_147000_g;
            if (i == ((FurnitureWorkbenchContainer)this.field_147002_h).getSelectedRecipe()) {
                j1 += 18;
            } else if (p_238853_2_ >= k && p_238853_3_ >= i1 && p_238853_2_ < k + 16 && p_238853_3_ < i1 + 18) {
                j1 += 36;
            }
            this.func_238474_b_(p_238853_1_, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void drawRecipesItems(int left, int top, int recipeIndexOffsetMax) {
        List<FurnitureRecipe> list = ((FurnitureWorkbenchContainer)this.field_147002_h).getRecipeList();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((FurnitureWorkbenchContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            this.field_230706_i_.func_175599_af().func_180450_b(list.get(i).func_77571_b(), k, i1);
        }
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        this.clickedOnScroll = false;
        if (this.hasItemsInInputSlot) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = p_231044_1_ - (double)(i + i1 % 4 * 16);
                double d1 = p_231044_3_ - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((FurnitureWorkbenchContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.field_230706_i_.field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187885_gS, (float)1.0f));
                this.field_230706_i_.field_71442_b.func_78756_a(((FurnitureWorkbenchContainer)this.field_147002_h).field_75152_c, l);
                return true;
            }
            i = this.field_147003_i + 119;
            j = this.field_147009_r + 9;
            if (p_231044_1_ >= (double)i && p_231044_1_ < (double)(i + 12) && p_231044_3_ >= (double)j && p_231044_3_ < (double)(j + 54)) {
                this.clickedOnScroll = true;
            }
        }
        return super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    public boolean func_231045_a_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (this.clickedOnScroll && this.canScroll()) {
            int i = this.field_147009_r + 14;
            int j = i + 54;
            this.sliderProgress = ((float)p_231045_3_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.func_231045_a_(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
    }

    public boolean func_231043_a_(double p_231043_1_, double p_231043_3_, double p_231043_5_) {
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - p_231043_5_ / (double)i);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((FurnitureWorkbenchContainer)this.field_147002_h).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((FurnitureWorkbenchContainer)this.field_147002_h).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((FurnitureWorkbenchContainer)this.field_147002_h).hasItemsInInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

