/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.item.Letter;
import io.github.wouink.furnish.network.ItemStackUpdateMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.fonts.TextInputUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LetterScreen
extends Screen {
    private static final ITextComponent SCREEN_NAME = new TranslationTextComponent("item.furnish.letter");
    private static final TranslationTextComponent SIGN_LETTER = new TranslationTextComponent("book.signButton");
    private static final ResourceLocation LETTER_BACKGROUND = new ResourceLocation("furnish", "textures/gui/letter.png");
    private static final int LETTER_MAX_LENGTH = 288;
    private Hand hand;
    private ItemStack letter;
    private PlayerEntity playerEntity;
    private boolean editable = false;
    private String letterText;
    private TextInputUtil letterEdit = null;
    private int frameTick = 0;

    public LetterScreen(ItemStack letter, PlayerEntity playerEntity, Hand hand) {
        super(SCREEN_NAME);
        this.hand = hand;
        this.letter = letter;
        this.playerEntity = playerEntity;
        CompoundNBT tag = letter.func_196082_o();
        this.letterText = tag.func_150296_c().contains("Text") ? tag.func_74779_i("Text") : "";
        this.editable = Letter.canEditLetter(letter);
        if (this.editable) {
            this.letterEdit = new TextInputUtil(this::getText, this::setText, this::getClipboard, this::setClipboard, s -> s.length() < 288);
        }
    }

    private void setClipboard(String s) {
        if (this.field_230706_i_ != null) {
            TextInputUtil.func_238571_a_((Minecraft)this.field_230706_i_, (String)s);
        }
    }

    private String getClipboard() {
        return this.field_230706_i_ != null ? TextInputUtil.func_238576_b_((Minecraft)this.field_230706_i_) : "";
    }

    private String getText() {
        return this.letterText;
    }

    private void setText(String s) {
        this.letterText = s;
    }

    private void save() {
        CompoundNBT tag = this.letter.func_196082_o();
        tag.func_74778_a("Text", this.getText());
        this.letter.func_77982_d(tag);
    }

    private void sendUpdate() {
        int slot = this.hand == Hand.MAIN_HAND ? this.playerEntity.field_71071_by.field_70461_c : 40;
        Furnish.networkChannel.sendToServer((Object)new ItemStackUpdateMessage(slot, this.letter));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.editable) {
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 102, 196, 100, 20, (ITextComponent)SIGN_LETTER, var -> {
                this.save();
                Letter.signLetter(this.letter, this.playerEntity.func_146103_bH().getName());
                this.sendUpdate();
                this.field_230706_i_.func_147108_a(null);
            }));
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 2, 196, 100, 20, DialogTexts.field_240632_c_, var -> {
                this.save();
                this.sendUpdate();
                this.field_230706_i_.func_147108_a(null);
            }));
        } else {
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50, 196, 100, 20, DialogTexts.field_240632_c_, var -> this.field_230706_i_.func_147108_a(null)));
        }
    }

    public boolean func_231042_a_(char c, int n) {
        if (super.func_231042_a_(c, n)) {
            return true;
        }
        if (this.editable && SharedConstants.func_71566_a((char)c)) {
            this.letterEdit.func_216892_a(Character.toString(c));
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int key, int m, int n) {
        if (key == 256 && this.func_231178_ax__()) {
            this.func_231175_as__();
            return true;
        }
        if (this.editable) {
            if (Screen.func_231170_j_((int)key)) {
                this.letterEdit.func_238585_d_();
                return true;
            }
            if (Screen.func_231169_i_((int)key)) {
                this.letterEdit.func_238580_c_();
                return true;
            }
            if (Screen.func_231166_g_((int)key)) {
                this.letterEdit.func_238567_a_();
                return true;
            }
            if (Screen.func_231168_h_((int)key)) {
                this.letterEdit.func_238574_b_();
                return true;
            }
            switch (key) {
                case 257: 
                case 335: {
                    this.letterEdit.func_216892_a("\n");
                    return true;
                }
                case 259: {
                    this.letterEdit.func_238586_d_(-1);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.field_230706_i_.func_110434_K().func_110577_a(LETTER_BACKGROUND);
        int startX = (this.field_230708_k_ - 192) / 2;
        this.func_238474_b_(ms, startX, 2, 0, 0, 192, 192);
        if (this.editable) {
            if (this.frameTick / 6 % 2 == 0) {
                this.field_230712_o_.func_238418_a_((ITextProperties)new StringTextComponent(this.letterText).func_240702_b_("_"), startX + 36, 20, 108, 0);
            } else {
                this.field_230712_o_.func_238418_a_((ITextProperties)new StringTextComponent(this.letterText).func_240702_b_(" "), startX + 36, 20, 108, 0);
            }
        } else {
            this.field_230712_o_.func_238418_a_((ITextProperties)new StringTextComponent(this.letterText), startX + 36, 20, 108, 0);
        }
    }

    public void func_230446_a_(MatrixStack ms) {
        super.func_230446_a_(ms);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.editable) {
            ++this.frameTick;
        }
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_231175_as__() {
        super.func_231175_as__();
    }
}

