/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.wouink.furnish.block.tileentity.MailboxTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class MailboxRenderer
extends TileEntityRenderer<MailboxTileEntity> {
    public MailboxRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(MailboxTileEntity mailbox, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (this.shouldShowName(mailbox)) {
            this.renderNameTag(mailbox, ms, buffer, light);
        }
    }

    private boolean shouldShowName(MailboxTileEntity mailbox) {
        if (!mailbox.hasOwner()) {
            return false;
        }
        if (this.field_228858_b_.field_190057_j.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)this.field_228858_b_.field_190057_j;
            return blockRayTraceResult.func_216350_a().equals((Object)mailbox.func_174877_v());
        }
        return false;
    }

    private void renderNameTag(MailboxTileEntity mailbox, MatrixStack ms, IRenderTypeBuffer buffer, int light) {
        if (!Minecraft.func_71382_s()) {
            return;
        }
        ITextComponent content = mailbox.getOwnerDisplayName();
        if (content == null) {
            content = new StringTextComponent("???");
        }
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 1.0, 0.5);
        ms.func_227863_a_(this.field_228858_b_.field_217666_g.func_227995_f_());
        ms.func_227862_a_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = ms.func_227866_c_().func_227870_a_();
        float backOpacity = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
        int alpha = (int)(backOpacity * 255.0f) << 24;
        FontRenderer fontRenderer = this.field_228858_b_.func_147548_a();
        float centerOffset = -fontRenderer.func_238414_a_((ITextProperties)content) / 2;
        fontRenderer.func_243247_a(content, centerOffset, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, false, alpha, light);
        fontRenderer.func_243247_a(content, centerOffset, 0.0f, -1, false, matrix4f, buffer, false, 0, light);
        ms.func_227865_b_();
    }
}

