/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.wouink.furnish.block.Plate;
import io.github.wouink.furnish.block.tileentity.ShelfTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;

public class ShelfRenderer
extends TileEntityRenderer<ShelfTileEntity> {
    public ShelfRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(ShelfTileEntity shelf, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        ItemStack stack = shelf.getHeldItem();
        if (!stack.func_190926_b()) {
            ms.func_227860_a_();
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            boolean blockItem = itemRenderer.func_184393_a(stack, shelf.func_145831_w(), null).func_177556_c();
            Direction dir = ((Direction)shelf.func_195044_w().func_177229_b((Property)Plate.field_185512_D)).func_176734_d();
            if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof Plate) {
                this.prepareRenderPlate(ms, dir);
            } else if (blockItem) {
                this.prepareRenderBlock(ms, dir);
            } else {
                this.prepareRenderItem(ms, dir);
            }
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
            ms.func_227865_b_();
        }
    }

    public void prepareRenderItem(MatrixStack ms, Direction dir) {
        switch (dir) {
            case NORTH: {
                ms.func_227861_a_(0.5, 0.5, 0.125);
                break;
            }
            case SOUTH: {
                ms.func_227861_a_(0.5, 0.5, 0.875);
                break;
            }
            case WEST: {
                ms.func_227861_a_(0.125, 0.5, 0.5);
                break;
            }
            default: {
                ms.func_227861_a_(0.875, 0.5, 0.5);
            }
        }
        float angle = -dir.func_185119_l();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        ms.func_227862_a_(0.6f, 0.6f, 0.6f);
    }

    public void prepareRenderBlock(MatrixStack ms, Direction dir) {
        switch (dir) {
            case NORTH: {
                ms.func_227861_a_(0.5, 0.35, 0.15);
                break;
            }
            case SOUTH: {
                ms.func_227861_a_(0.5, 0.35, 0.85);
                break;
            }
            case WEST: {
                ms.func_227861_a_(0.15, 0.35, 0.5);
                break;
            }
            default: {
                ms.func_227861_a_(0.85, 0.35, 0.5);
            }
        }
        float angle = -dir.func_185119_l();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        ms.func_227862_a_(0.6f, 0.6f, 0.6f);
    }

    public void prepareRenderPlate(MatrixStack ms, Direction dir) {
        switch (dir) {
            case NORTH: {
                ms.func_227861_a_(0.5, 0.5, 0.35);
                break;
            }
            case SOUTH: {
                ms.func_227861_a_(0.5, 0.5, 0.65);
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
            case WEST: {
                ms.func_227861_a_(0.35, 0.5, 0.5);
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
            default: {
                ms.func_227861_a_(0.65, 0.5, 0.5);
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
            }
        }
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(80.0f));
        ms.func_227862_a_(1.0f, 1.0f, 1.0f);
    }
}

