/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.event;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.setup.FurnishData;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.entity.item.PaintingType;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CustomPaintings {
    public static void registerCustomPaintings(IForgeRegistry<PaintingType> paintingRegistry, String jsonFilePath) {
        block10: {
            Furnish.LOG.info(String.format("Custom paintings: attempt to load file %s.", jsonFilePath));
            File f = new File(jsonFilePath);
            if (f.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(f.toPath(), new OpenOption[0])));
                    Gson builder = new GsonBuilder().create();
                    JsonObject paintingsFile = ((JsonElement)builder.fromJson((Reader)reader, JsonElement.class)).getAsJsonObject();
                    JsonArray paintings = paintingsFile.getAsJsonArray("paintings");
                    if (paintings != null) {
                        for (int index = 0; index < paintings.size(); ++index) {
                            JsonObject painting = paintings.get(index).getAsJsonObject();
                            if (!painting.has("name")) {
                                Furnish.LOG.error(String.format("%s: Painting at index %d has no name. Skipping.", jsonFilePath, index));
                                continue;
                            }
                            String name = painting.get("name").getAsString();
                            if (!painting.has("w")) {
                                Furnish.LOG.error(String.format("%s: Painting with name %s at index %d has no width. Skipping.", jsonFilePath, name, index));
                                continue;
                            }
                            int w = painting.get("w").getAsInt();
                            if (!painting.has("h")) {
                                Furnish.LOG.error(String.format("%s: Painting with name %s at index %d has no height. Skipping.", jsonFilePath, name, index));
                                continue;
                            }
                            int h = painting.get("h").getAsInt();
                            if (w < 1 || h < 1) {
                                Furnish.LOG.error(String.format("%s: Painting with name %s at index %d has invalid dimension. Skipping.", jsonFilePath, name, index));
                                continue;
                            }
                            paintingRegistry.register((IForgeRegistryEntry)FurnishData.createPainting(name, w, h));
                        }
                        break block10;
                    }
                    Furnish.LOG.error("No paintings element in paintings.json file.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Furnish.LOG.error(String.format("Could not load %s.", jsonFilePath));
                }
            } else {
                Furnish.LOG.info(String.format("File not found: %s", jsonFilePath));
            }
        }
    }
}

