/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CyclePainting {
    public static List<PaintingType> getSimilarSizeArt(PaintingType art) {
        ArrayList<PaintingType> similar = new ArrayList<PaintingType>();
        for (PaintingType p : ForgeRegistries.PAINTING_TYPES.getValues()) {
            if (p.func_200834_b() != art.func_200834_b() || p.func_200832_c() != art.func_200832_c()) continue;
            similar.add(p);
        }
        return similar;
    }

    @SubscribeEvent
    public static void onPaintingInteract(PlayerInteractEvent.EntityInteract event) {
        World world = event.getWorld();
        if (world.func_201670_d()) {
            return;
        }
        if (!event.getItemStack().func_77973_b().equals(Items.field_151159_an)) {
            return;
        }
        if (!(event.getTarget() instanceof PaintingEntity)) {
            return;
        }
        PaintingEntity target = (PaintingEntity)event.getTarget();
        PaintingType newArt = null;
        List<PaintingType> similarSizeArts = CyclePainting.getSimilarSizeArt(target.field_70522_e);
        if (similarSizeArts.isEmpty() || similarSizeArts.size() < 2) {
            event.getPlayer().func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.cycle_no_painting"), true);
            return;
        }
        if (event.getPlayer().func_213453_ef()) {
            Collections.reverse(similarSizeArts);
        }
        int index = similarSizeArts.indexOf(target.field_70522_e);
        newArt = similarSizeArts.get((index + 1) % similarSizeArts.size());
        PaintingEntity newPainting = new PaintingEntity(world, target.func_174857_n(), target.func_184172_bi());
        newPainting.field_70522_e = newArt;
        target.func_70106_y();
        world.func_217376_c((Entity)newPainting);
    }
}

