/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.integration.jei;

import io.github.wouink.furnish.integration.jei.FurnishPlugin;
import io.github.wouink.furnish.recipe.FurnitureRecipe;
import io.github.wouink.furnish.setup.FurnishBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class FurnitureMakingCategory
implements IRecipeCategory<FurnitureRecipe> {
    public static final ResourceLocation FURNITURE_MAKING = new ResourceLocation("furnish", "furniture_making");
    private final IDrawable background;
    private final IDrawable icon;
    private static final int inputSlot = 0;
    private static final int outputSlot = 1;
    public static final int width = 82;
    public static final int height = 34;

    public FurnitureMakingCategory(IGuiHelper guiHelper) {
        ResourceLocation loc = FurnishPlugin.RECIPE_GUI_FURNISH;
        this.background = guiHelper.createDrawable(loc, 0, 220, 82, 34);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)FurnishBlocks.Furniture_Workbench));
    }

    public ResourceLocation getUid() {
        return FURNITURE_MAKING;
    }

    public Class<? extends FurnitureRecipe> getRecipeClass() {
        return FurnitureRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"furnish.furniture_making", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FurnitureRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, FurnitureRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        guiItemStackGroup.init(0, true, 0, 8);
        guiItemStackGroup.init(1, false, 60, 8);
        guiItemStackGroup.set(ingredients);
    }
}

