/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.item;

import io.github.wouink.furnish.client.gui.LetterScreen;
import io.github.wouink.furnish.setup.FurnishData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Letter
extends Item {
    public Letter(Item.Properties p, String registryName) {
        super(p);
        this.setRegistryName("furnish", registryName);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGui(ItemStack stack, PlayerEntity playerEntity, Hand hand) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f, (float)1.0f));
        Minecraft.func_71410_x().func_147108_a((Screen)new LetterScreen(stack, playerEntity, hand));
    }

    public void func_77624_a(ItemStack letter, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag tooltipFlag) {
        if (letter.func_77942_o()) {
            CompoundNBT letterTag = letter.func_77978_p();
            if (letterTag.func_74764_b("Author")) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.furnish.letter.author", new Object[]{letterTag.func_74779_i("Author")}).func_240699_a_(TextFormatting.GRAY));
            }
            if (letterTag.func_74764_b("Attachment")) {
                ItemStack attachment = ItemStack.func_199557_a((CompoundNBT)letterTag.func_74775_l("Attachment"));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.furnish.letter.attachment", new Object[]{attachment.func_77973_b().func_200296_o()}).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    public static ItemStack addAttachment(ItemStack letter, ItemStack attachment) {
        CompoundNBT letterTag = letter.func_196082_o();
        if (!letterTag.func_74764_b("Attachment")) {
            CompoundNBT attachmentTag = new CompoundNBT();
            letterTag.func_218657_a("Attachment", (INBT)attachment.func_77955_b(attachmentTag));
            letter.func_77982_d(letterTag);
            return ItemStack.field_190927_a;
        }
        return attachment;
    }

    public static ItemStack removeAttachment(ItemStack letter) {
        CompoundNBT letterTag = letter.func_196082_o();
        if (letterTag.func_74764_b("Attachment")) {
            ItemStack attachment = ItemStack.func_199557_a((CompoundNBT)letterTag.func_74775_l("Attachment"));
            letterTag.func_82580_o("Attachment");
            letter.func_77982_d(letterTag);
            return attachment;
        }
        return ItemStack.field_190927_a;
    }

    public static void signLetter(ItemStack letter, String author) {
        CompoundNBT letterTag = letter.func_196082_o();
        if (!letterTag.func_74764_b("Author")) {
            letterTag.func_74778_a("Author", author);
        }
        letter.func_77982_d(letterTag);
    }

    public static boolean canEditLetter(ItemStack letter) {
        CompoundNBT letterTag = letter.func_196082_o();
        return !letterTag.func_74764_b("Author");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        ItemStack letter = playerEntity.func_184586_b(hand);
        if (playerEntity.func_213453_ef()) {
            if (hand != Hand.OFF_HAND) {
                ItemStack result = Letter.removeAttachment(letter);
                if (!result.func_190926_b()) {
                    playerEntity.func_191521_c(result);
                    if (world.func_201670_d()) {
                        playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.letter.attachment_removed"), true);
                        playerEntity.func_184185_a((SoundEvent)FurnishData.Sounds.Detach_From_Letter.get(), 1.0f, 1.0f);
                    }
                    return ActionResult.func_233538_a_((Object)letter, (boolean)world.func_201670_d());
                }
                ItemStack offHandStack = playerEntity.func_184586_b(Hand.OFF_HAND);
                if (!offHandStack.func_190926_b()) {
                    result = Letter.addAttachment(letter, offHandStack);
                    playerEntity.func_184611_a(Hand.OFF_HAND, result);
                    if (result.func_190926_b()) {
                        if (world.func_201670_d()) {
                            playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("msg.furnish.letter.attachment_added", new Object[]{offHandStack.func_77973_b().func_200296_o()}), true);
                            playerEntity.func_184185_a((SoundEvent)FurnishData.Sounds.Attach_To_Letter.get(), 1.0f, 1.0f);
                        }
                        return ActionResult.func_233538_a_((Object)letter, (boolean)world.func_201670_d());
                    }
                }
                return ActionResult.func_226251_d_((Object)letter);
            }
            return ActionResult.func_226251_d_((Object)letter);
        }
        if (world.func_201670_d()) {
            this.openGui(letter, playerEntity, hand);
        }
        return ActionResult.func_233538_a_((Object)letter, (boolean)world.func_201670_d());
    }
}

