/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.network;

import io.github.wouink.furnish.network.ItemStackUpdateMessage;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class ServerMessageHandler {
    public static void onMessageReceived(ItemStackUpdateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived.isClient()) {
            System.err.println("Received an ItemStackUpdateMessage on client.");
            return;
        }
        ServerPlayerEntity playerEntity = ctx.getSender();
        if (playerEntity == null) {
            System.err.println("ServerPlayerEntity was null when ItemStackUpdateMessage was received.");
            return;
        }
        ctx.enqueueWork(() -> ServerMessageHandler.processMessage(message, playerEntity));
    }

    private static void processMessage(ItemStackUpdateMessage message, ServerPlayerEntity playerEntity) {
        playerEntity.field_71071_by.func_70299_a(message.getSlot(), message.getStack());
        playerEntity.field_71071_by.func_70296_d();
    }

    public static boolean acceptsProtocol(String protocol) {
        return "1.0".equals(protocol);
    }
}

