/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.block.tileentity.PlateTileEntity;
import io.github.wouink.furnish.block.util.ISpecialItemProperties;
import io.github.wouink.furnish.setup.FurnishItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class Plate
extends HorizontalDirectionalBlock
implements EntityBlock,
ISpecialItemProperties {
    public static final VoxelShape PLATE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final TagKey WHITELIST = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("furnish", "food"));

    public Plate(BlockBehaviour.Properties p) {
        super(p.m_60955_().m_60999_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return PLATE_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tileEntity;
        InteractionResult resultType = InteractionResult.FAIL;
        if (!world.m_5776_() && (playerEntity.m_21120_(hand).m_41619_() || playerEntity.m_21120_(hand).m_41614_() || playerEntity.m_21120_(hand).m_204117_(WHITELIST)) && (tileEntity = world.m_7702_(pos)) instanceof PlateTileEntity) {
            playerEntity.m_21008_(hand, ((PlateTileEntity)tileEntity).swap(playerEntity.m_21120_(hand)));
            resultType = InteractionResult.SUCCESS;
        }
        return resultType == InteractionResult.SUCCESS ? InteractionResult.m_19078_((boolean)world.m_5776_()) : resultType;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PlateTileEntity(pos, state);
    }

    @Override
    public Item.Properties getProperties() {
        Rarity rarity = ForgeRegistries.BLOCKS.getKey((Object)this).m_135815_().startsWith("rare_") ? Rarity.RARE : Rarity.COMMON;
        return new Item.Properties().m_41491_(FurnishItems.Furnish_ItemGroup).m_41487_(16).m_41497_(rarity);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        ItemStack stack;
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof PlateTileEntity && !(stack = ((PlateTileEntity)tileEntity).getHeldItem().m_41777_()).m_41619_()) {
            stack.m_41764_(1);
            return stack;
        }
        return super.m_7397_(world, pos, state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moving) {
        ItemStack stack;
        BlockEntity tileEntity;
        if (state.m_60734_() != newState.m_60734_() && (tileEntity = world.m_7702_(pos)) instanceof PlateTileEntity && !(stack = ((PlateTileEntity)tileEntity).getHeldItem()).m_41619_()) {
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack));
        }
        super.m_6810_(state, world, pos, newState, moving);
    }
}

