/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CyclePainting {
    public static List<PaintingVariant> getSimilarSizeArt(PaintingVariant art) {
        ArrayList<PaintingVariant> similar = new ArrayList<PaintingVariant>();
        for (PaintingVariant p : ForgeRegistries.PAINTING_VARIANTS.getValues()) {
            if (p.m_218908_() != art.m_218908_() || p.m_218909_() != art.m_218909_()) continue;
            similar.add(p);
        }
        return similar;
    }

    @SubscribeEvent
    public static void onPaintingInteract(PlayerInteractEvent.EntityInteract event) {
        Level world = event.getLevel();
        if (world.m_5776_()) {
            return;
        }
        if (!event.getItemStack().m_41720_().equals(Items.f_42487_)) {
            return;
        }
        if (!(event.getTarget() instanceof Painting)) {
            return;
        }
        Painting target = (Painting)event.getTarget();
        PaintingVariant newArt = null;
        List<PaintingVariant> similarSizeArts = CyclePainting.getSimilarSizeArt((PaintingVariant)target.m_218901_().get());
        if (similarSizeArts.isEmpty() || similarSizeArts.size() < 2) {
            event.getEntity().m_5661_((Component)Component.m_237115_((String)"msg.furnish.cycle_no_painting"), true);
            return;
        }
        if (event.getEntity().m_6047_()) {
            Collections.reverse(similarSizeArts);
        }
        int index = similarSizeArts.indexOf(target.m_218901_().get());
        newArt = similarSizeArts.get((index + 1) % similarSizeArts.size());
        Painting newPainting = new Painting(world, target.m_31748_(), target.m_6374_(), (Holder)newArt);
        target.m_142687_(Entity.RemovalReason.DISCARDED);
        world.m_7967_((Entity)newPainting);
    }
}

