/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block.container;

import com.google.common.collect.Lists;
import io.github.wouink.furnish.recipe.FurnitureRecipe;
import io.github.wouink.furnish.setup.FurnishBlocks;
import io.github.wouink.furnish.setup.FurnishData;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class FurnitureWorkbenchContainer
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Level level;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private List<FurnitureRecipe> recipes = Lists.newArrayList();
    private ItemStack itemStackInput = ItemStack.f_41583_;
    private long lastOnTake;
    final Slot inputSlot;
    final Slot outputSlot;
    private Runnable inventoryUpdateListener = () -> {};
    public final Container inputContainer = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            FurnitureWorkbenchContainer.this.m_6199_((Container)this);
            FurnitureWorkbenchContainer.this.inventoryUpdateListener.run();
        }
    };
    private final ResultContainer resultContainer = new ResultContainer();

    public FurnitureWorkbenchContainer(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public FurnitureWorkbenchContainer(int syncId, Inventory playerInventory, ContainerLevelAccess posCallable) {
        super((MenuType)FurnishData.Containers.Furniture_Workbench.get(), syncId);
        this.access = posCallable;
        this.level = playerInventory.f_35978_.f_19853_;
        this.inputSlot = this.m_38897_(new Slot(this.inputContainer, 0, 20, 33));
        this.outputSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player thePlayer, ItemStack stack) {
                ItemStack itemStack = FurnitureWorkbenchContainer.this.inputSlot.m_6201_(1);
                if (!itemStack.m_41619_()) {
                    FurnitureWorkbenchContainer.this.updateRecipeResultSlot();
                }
                stack.m_41720_().m_7836_(stack, thePlayer.f_19853_, thePlayer);
                FurnitureWorkbenchContainer.this.access.m_39292_((world, pos) -> {
                    long l = world.m_46467_();
                    if (FurnitureWorkbenchContainer.this.lastOnTake != l) {
                        world.m_5594_(null, pos, SoundEvents.f_12630_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        FurnitureWorkbenchContainer.this.lastOnTake = l;
                    }
                });
                super.m_142406_(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipe);
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    public List<FurnitureRecipe> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemsInInputSlot() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player playerIn) {
        return FurnitureWorkbenchContainer.m_38889_((ContainerLevelAccess)this.access, (Player)playerIn, (Block)((Block)FurnishBlocks.Furniture_Workbench.get()));
    }

    public boolean m_6366_(Player playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipe.m_6422_(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    public boolean isValidRecipeIndex(int n) {
        return n >= 0 && n < this.getRecipeListSize();
    }

    public void m_6199_(Container inv) {
        ItemStack itemStack = this.inputSlot.m_7993_();
        if (itemStack.m_41720_() != this.itemStackInput.m_41720_()) {
            this.itemStackInput = itemStack.m_41777_();
            this.updateAvailableRecipes(inv, itemStack);
        }
    }

    private void updateAvailableRecipes(Container inv, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.m_6422_(-1);
        this.outputSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_(FurnishData.Furniture_Recipe, inv, this.level);
        }
    }

    public void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipe.m_6501_())) {
            FurnitureRecipe recipe = this.recipes.get(this.selectedRecipe.m_6501_());
            this.outputSlot.m_5852_(recipe.m_5874_(this.inputContainer));
        } else {
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)FurnishData.Containers.Furniture_Workbench.get();
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            Item item = itemStack1.m_41720_();
            itemStack = itemStack1.m_41777_();
            if (index == 1) {
                item.m_7836_(itemStack1, playerIn.f_19853_, playerIn);
                if (!this.m_38903_(itemStack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack1, itemStack);
            } else if (index == 0 ? !this.m_38903_(itemStack1, 2, 38, false) : (this.level.m_7465_().m_44015_(FurnishData.Furniture_Recipe, (Container)new SimpleContainer(new ItemStack[]{itemStack1}), this.level).isPresent() ? !this.m_38903_(itemStack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(itemStack1, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(itemStack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemStack1.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemStack1);
            this.m_38946_();
        }
        return itemStack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((world, pos) -> this.m_150411_(playerIn, this.inputContainer));
    }
}

