/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import com.google.common.collect.ImmutableMap;
import io.github.wouink.furnish.block.util.PlacementHelper;
import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.setup.FurnishBlocks;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Shutter
extends HorizontalDirectionalBlock {
    private static final VoxelShape[] SHUTTER_CLOSED = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0));
    private static final VoxelShape[] SHUTTER_HALF_OPENED = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape[] SHUTTER_HALF_OPENED_R = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));
    private static final VoxelShape[] SHUTTER_OPENED = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)30.0));
    private static final VoxelShape[] SHUTTER_OPENED_R = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)0.0, (double)0.0, (double)-14.0, (double)2.0, (double)16.0, (double)2.0));
    private static final VoxelShape[] INTERACT_HALF = VoxelShapeHelper.getMergedShapes(SHUTTER_CLOSED, SHUTTER_HALF_OPENED);
    private static final VoxelShape[] INTERACT_HALF_R = VoxelShapeHelper.getMergedShapes(SHUTTER_CLOSED, SHUTTER_HALF_OPENED_R);
    private static final VoxelShape[] INTERACT_OPEN = VoxelShapeHelper.getMergedShapes(SHUTTER_CLOSED, SHUTTER_OPENED);
    private static final VoxelShape[] INTERACT_OPEN_R = VoxelShapeHelper.getMergedShapes(SHUTTER_CLOSED, SHUTTER_OPENED_R);
    public static final BooleanProperty RIGHT = FurnishBlocks.CustomProperties.RIGHT;
    public static final EnumProperty<State> STATE = EnumProperty.m_61587_((String)"state", State.class);

    public Shutter(BlockBehaviour.Properties p) {
        super(p.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(STATE, (Comparable)((Object)State.CLOSED))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, STATE, RIGHT});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(PlacementHelper.placeRight(ctx)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult hitResult) {
        if (world.m_7731_(pos, (BlockState)state.m_61122_(STATE), 3)) {
            world.m_5594_(playerEntity, pos, SoundEvents.f_12629_, SoundSource.BLOCKS, 1.0f, 1.0f);
            boolean rightProp = (Boolean)world.m_8055_(pos).m_61143_((Property)RIGHT);
            BlockPos scan = pos.m_7495_();
            while (world.m_8055_(scan).m_60734_() == this && (Boolean)world.m_8055_(scan).m_61143_((Property)RIGHT) == rightProp) {
                world.m_7731_(scan, world.m_8055_(pos), 3);
                scan = scan.m_7495_();
            }
            scan = pos.m_7494_();
            while (world.m_8055_(scan).m_60734_() == this && (Boolean)world.m_8055_(scan).m_61143_((Property)RIGHT) == rightProp) {
                world.m_7731_(scan, world.m_8055_(pos), 3);
                scan = scan.m_7494_();
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected ImmutableMap<BlockState, VoxelShape> m_152458_(Function<BlockState, VoxelShape> p_152459_) {
        return super.m_152458_(p_152459_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        int index = ((Direction)state.m_61143_((Property)f_54117_)).ordinal() - 2;
        if (state.m_61143_(STATE) == State.HALF_OPEN) {
            return (Boolean)state.m_61143_((Property)RIGHT) != false ? INTERACT_HALF_R[index] : INTERACT_HALF[index];
        }
        if (state.m_61143_(STATE) == State.OPEN) {
            return (Boolean)state.m_61143_((Property)RIGHT) != false ? INTERACT_OPEN_R[index] : INTERACT_OPEN[index];
        }
        return SHUTTER_CLOSED[index];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        int index = ((Direction)state.m_61143_((Property)f_54117_)).ordinal() - 2;
        if (state.m_61143_(STATE) == State.HALF_OPEN) {
            return (Boolean)state.m_61143_((Property)RIGHT) != false ? SHUTTER_HALF_OPENED_R[index] : SHUTTER_HALF_OPENED[index];
        }
        if (state.m_61143_(STATE) == State.OPEN) {
            return (Boolean)state.m_61143_((Property)RIGHT) != false ? SHUTTER_OPENED_R[index] : SHUTTER_OPENED[index];
        }
        return SHUTTER_CLOSED[index];
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public static enum State implements StringRepresentable
    {
        CLOSED("closed"),
        HALF_OPEN("half_open"),
        OPEN("open");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

