/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.block;

import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.entity.SeatEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Sofa
extends HorizontalDirectionalBlock {
    private static final VoxelShape[] SEAT = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0));
    private static final VoxelShape[] SITTING = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)13.0, (double)6.0, (double)16.0));
    private static final VoxelShape[] REST_L = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)15.0, (double)10.0, (double)3.0));
    private static final VoxelShape[] REST_R = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)4.0, (double)0.0, (double)13.0, (double)15.0, (double)10.0, (double)16.0));
    private static final VoxelShape[] SEAT_L = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0));
    private static final VoxelShape[] SEAT_R = VoxelShapeHelper.getRotatedShapes(Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape[] MIDDLE_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING);
    private static final VoxelShape[] ARMCHAIR_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING, REST_L, REST_R);
    private static final VoxelShape[] RIGHT_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING, REST_L);
    private static final VoxelShape[] LEFT_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING, REST_R);
    private static final VoxelShape[] RIGHT_CORNER_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING, SEAT_L);
    private static final VoxelShape[] LEFT_CORNER_SHAPE = VoxelShapeHelper.getMergedShapes(SEAT, SITTING, SEAT_R);
    public static final EnumProperty<SofaType> SOFA_TYPE = EnumProperty.m_61587_((String)"type", SofaType.class);

    public Sofa(BlockBehaviour.Properties p) {
        super(p.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(SOFA_TYPE, (Comparable)((Object)SofaType.ARMCHAIR)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, SOFA_TYPE});
    }

    private BlockState setBlockState(BlockState state, Direction dir, BlockPos pos, LevelAccessor world) {
        BlockState front;
        boolean right;
        BlockState leftState = world.m_8055_(pos.m_142300_(dir.m_122428_()));
        BlockState rightState = world.m_8055_(pos.m_142300_(dir.m_122427_()));
        boolean left = leftState.m_60734_() instanceof Sofa && (leftState.m_61143_((Property)f_54117_) == state.m_61143_((Property)f_54117_) || leftState.m_61143_(SOFA_TYPE) == SofaType.CORNER_RIGHT);
        boolean bl = right = rightState.m_60734_() instanceof Sofa && (rightState.m_61143_((Property)f_54117_) == state.m_61143_((Property)f_54117_) || rightState.m_61143_(SOFA_TYPE) == SofaType.CORNER_LEFT);
        state = left && right ? (BlockState)state.m_61124_(SOFA_TYPE, (Comparable)((Object)SofaType.MIDDLE)) : (left ? ((front = world.m_8055_(pos.m_142300_((Direction)state.m_61143_((Property)f_54117_)))).m_60734_() instanceof Sofa && front.m_61143_((Property)f_54117_) == ((Direction)state.m_61143_((Property)f_54117_)).m_122427_() ? (BlockState)state.m_61124_(SOFA_TYPE, (Comparable)((Object)SofaType.CORNER_RIGHT)) : (BlockState)state.m_61124_(SOFA_TYPE, (Comparable)((Object)SofaType.RIGHT))) : (right ? ((front = world.m_8055_(pos.m_142300_((Direction)state.m_61143_((Property)f_54117_)))).m_60734_() instanceof Sofa && front.m_61143_((Property)f_54117_) == ((Direction)state.m_61143_((Property)f_54117_)).m_122428_() ? (BlockState)state.m_61124_(SOFA_TYPE, (Comparable)((Object)SofaType.CORNER_LEFT)) : (BlockState)state.m_61124_(SOFA_TYPE, (Comparable)((Object)SofaType.LEFT))) : (BlockState)state.m_61124_(SOFA_TYPE, (Comparable)((Object)SofaType.ARMCHAIR))));
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        int index = ((Direction)state.m_61143_((Property)f_54117_)).ordinal() - 2;
        VoxelShape ret = ARMCHAIR_SHAPE[index];
        switch (((SofaType)((Object)state.m_61143_(SOFA_TYPE))).ordinal()) {
            case 1: {
                ret = LEFT_SHAPE[index];
                break;
            }
            case 2: {
                ret = RIGHT_SHAPE[index];
                break;
            }
            case 3: {
                ret = MIDDLE_SHAPE[index];
                break;
            }
            case 4: {
                ret = LEFT_CORNER_SHAPE[index];
                break;
            }
            case 5: {
                ret = RIGHT_CORNER_SHAPE[index];
                break;
            }
        }
        return ret;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState fromState, LevelAccessor level, BlockPos pos, BlockPos fromPos) {
        return this.setBlockState(state, ((Direction)state.m_61143_((Property)f_54117_)).m_122424_(), pos, level);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
        return this.setBlockState(state, ctx.m_8125_(), ctx.m_8083_(), (LevelAccessor)ctx.m_43725_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult hitResult) {
        return SeatEntity.create(world, pos, 0.2, playerEntity);
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float dist) {
        super.m_142072_(world, state, pos, entity, dist * 0.5f);
    }

    public void m_5548_(BlockGetter reader, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(reader, entity);
        } else {
            Sofa.bounceUp(entity);
        }
    }

    private static void bounceUp(Entity entity) {
        Vec3 vector3d = entity.m_20184_();
        if (vector3d.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vector3d.f_82479_, -vector3d.f_82480_ * (double)0.66f * d0, vector3d.f_82481_);
        }
    }

    public static enum SofaType implements StringRepresentable
    {
        ARMCHAIR("armchair"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String name;

        private SofaType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

