/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.wouink.furnish.Furnish;
import io.github.wouink.furnish.item.Letter;
import io.github.wouink.furnish.network.ItemStackUpdateMessage;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class LetterScreen
extends Screen {
    private static final Component SCREEN_NAME = new TranslatableComponent("item.furnish.letter");
    private static final Component SIGN_LETTER = new TranslatableComponent("book.signButton");
    private static final ResourceLocation LETTER_BACKGROUND = new ResourceLocation("furnish", "textures/gui/letter.png");
    private static final int LETTER_MAX_LENGTH = 288;
    private InteractionHand hand;
    private ItemStack letter;
    private Player playerEntity;
    private boolean editable = false;
    private String letterText;
    private TextFieldHelper letterEdit = null;
    private int frameTick = 0;

    public LetterScreen(ItemStack letter, Player playerEntity, InteractionHand hand) {
        super(SCREEN_NAME);
        this.hand = hand;
        this.letter = letter;
        this.playerEntity = playerEntity;
        CompoundTag tag = letter.m_41784_();
        this.letterText = tag.m_128431_().contains("Text") ? tag.m_128461_("Text") : "";
        this.editable = Letter.canEditLetter(letter);
        if (this.editable) {
            this.letterEdit = new TextFieldHelper(this::getText, this::setText, this::getClipboard, this::setClipboard, s -> s.length() < 288);
        }
    }

    private void setClipboard(String s) {
        if (this.f_96541_ != null) {
            TextFieldHelper.m_95155_((Minecraft)this.f_96541_, (String)s);
        }
    }

    private String getClipboard() {
        return this.f_96541_ != null ? TextFieldHelper.m_95169_((Minecraft)this.f_96541_) : "";
    }

    private String getText() {
        return this.letterText;
    }

    private void setText(String s) {
        this.letterText = s;
    }

    private void save() {
        CompoundTag tag = this.letter.m_41784_();
        tag.m_128359_("Text", this.getText());
        this.letter.m_41751_(tag);
    }

    private void sendUpdate() {
        int slot = this.hand == InteractionHand.MAIN_HAND ? this.playerEntity.m_150109_().f_35977_ : 40;
        Furnish.networkChannel.sendToServer((Object)new ItemStackUpdateMessage(slot, this.letter));
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.editable) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 102, 196, 100, 20, SIGN_LETTER, var -> {
                this.save();
                Letter.signLetter(this.letter, this.playerEntity.m_36316_().getName());
                this.sendUpdate();
                this.f_96541_.m_91152_(null);
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 2, 196, 100, 20, CommonComponents.f_130655_, var -> {
                this.save();
                this.sendUpdate();
                this.f_96541_.m_91152_(null);
            }));
        } else {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, 196, 100, 20, CommonComponents.f_130655_, var -> this.f_96541_.m_91152_(null)));
        }
    }

    public boolean m_5534_(char c, int n) {
        if (super.m_5534_(c, n)) {
            return true;
        }
        if (this.editable && SharedConstants.m_136188_((char)c)) {
            this.letterEdit.m_95158_(Character.toString(c));
            return true;
        }
        return false;
    }

    public boolean m_7933_(int key, int m, int n) {
        if (key == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if (this.editable) {
            if (Screen.m_96634_((int)key)) {
                this.letterEdit.m_95188_();
                return true;
            }
            if (Screen.m_96632_((int)key)) {
                this.letterEdit.m_95178_();
                return true;
            }
            if (Screen.m_96628_((int)key)) {
                this.letterEdit.m_95142_();
                return true;
            }
            if (Screen.m_96630_((int)key)) {
                this.letterEdit.m_95165_();
                return true;
            }
            switch (key) {
                case 257: 
                case 335: {
                    this.letterEdit.m_95158_("\n");
                    return true;
                }
                case 259: {
                    this.letterEdit.m_95189_(-1);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)LETTER_BACKGROUND);
        int startX = (this.f_96543_ - 192) / 2;
        this.m_93228_(ms, startX, 2, 0, 0, 192, 192);
        if (this.editable) {
            if (this.frameTick / 6 % 2 == 0) {
                this.f_96547_.m_92857_((FormattedText)new TextComponent(this.letterText).m_130946_("_"), startX + 36, 20, 108, 0);
            } else {
                this.f_96547_.m_92857_((FormattedText)new TextComponent(this.letterText).m_130946_(" "), startX + 36, 20, 108, 0);
            }
        } else {
            this.f_96547_.m_92857_((FormattedText)new TextComponent(this.letterText), startX + 36, 20, 108, 0);
        }
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.editable) {
            ++this.frameTick;
        }
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        super.m_7379_();
    }
}

