/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouink.furnish.setup;

import io.github.wouink.furnish.block.Amphora;
import io.github.wouink.furnish.block.Awning;
import io.github.wouink.furnish.block.BookPile;
import io.github.wouink.furnish.block.Bunting;
import io.github.wouink.furnish.block.Cabinet;
import io.github.wouink.furnish.block.CarpetOnStairs;
import io.github.wouink.furnish.block.CarpetOnTrapdoor;
import io.github.wouink.furnish.block.Chair;
import io.github.wouink.furnish.block.ChimneyCap;
import io.github.wouink.furnish.block.ChimneyConduit;
import io.github.wouink.furnish.block.Crate;
import io.github.wouink.furnish.block.Curtain;
import io.github.wouink.furnish.block.DiskRack;
import io.github.wouink.furnish.block.FurnitureWorkbench;
import io.github.wouink.furnish.block.InventoryFurniture;
import io.github.wouink.furnish.block.LanternBunting;
import io.github.wouink.furnish.block.Mailbox;
import io.github.wouink.furnish.block.PaperLamp;
import io.github.wouink.furnish.block.Plate;
import io.github.wouink.furnish.block.Shelf;
import io.github.wouink.furnish.block.Showcase;
import io.github.wouink.furnish.block.Shutter;
import io.github.wouink.furnish.block.SimpleFurniture;
import io.github.wouink.furnish.block.Sofa;
import io.github.wouink.furnish.block.Table;
import io.github.wouink.furnish.block.Wardrobe;
import io.github.wouink.furnish.block.util.VoxelShapeHelper;
import io.github.wouink.furnish.setup.FurnishData;
import java.util.HashMap;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class FurnishBlocks {
    public static final DeferredRegister<Block> Registry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"furnish");
    public static final Block Furniture_Workbench = FurnishBlocks.register("furniture_workbench", (Block)new FurnitureWorkbench());
    public static final Block Book_Pile = FurnishBlocks.register("book_pile", (Block)new BookPile(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60978_(0.2f)));
    public static final Block Oak_Table = FurnishBlocks.register("oak_table", new Table(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final Block Oak_Square_Table = FurnishBlocks.register("oak_square_table", (Block)new SimpleFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final Block Oak_Bedside_Table = FurnishBlocks.register("oak_bedside_table", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Oak_Kitchen_Cabinet = FurnishBlocks.register("oak_kitchen_cabinet", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Oak_Cabinet = FurnishBlocks.register("oak_cabinet", (Block)new Cabinet(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_), FurnishData.Sounds.Cabinet_Open, FurnishData.Sounds.Cabinet_Close));
    public static final Block Oak_Wardrobe = FurnishBlocks.register("oak_wardrobe", (Block)new Wardrobe(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_), FurnishData.Sounds.Cabinet_Open, FurnishData.Sounds.Cabinet_Close));
    public static final Block Oak_Stool = FurnishBlocks.register("oak_stool", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_), Chair.BASE_SHAPES));
    public static final Block Oak_Chair = FurnishBlocks.register("oak_chair", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_), VoxelShapeHelper.getMergedShapes(Chair.BASE_SHAPES, Chair.CHAIR_SEAT)));
    public static final Block Oak_Shutter = FurnishBlocks.register("oak_shutter", (Block)new Shutter(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_)));
    public static final Block Oak_Crate = FurnishBlocks.register("oak_crate", new Crate(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final Block Oak_Shelf = FurnishBlocks.register("oak_shelf", (Block)new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final Block Birch_Table = FurnishBlocks.register("birch_table", new Table(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_)));
    public static final Block Birch_Square_Table = FurnishBlocks.register("birch_square_table", (Block)new SimpleFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_)));
    public static final Block Birch_Bedside_Table = FurnishBlocks.register("birch_bedside_table", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Birch_Kitchen_Cabinet = FurnishBlocks.register("birch_kitchen_cabinet", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Birch_Cabinet = FurnishBlocks.register("birch_cabinet", (Block)new Cabinet(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_), FurnishData.Sounds.Cabinet_Open, FurnishData.Sounds.Cabinet_Close));
    public static final Block Birch_Wardrobe = FurnishBlocks.register("birch_wardrobe", (Block)new Wardrobe(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_), FurnishData.Sounds.Cabinet_Open, FurnishData.Sounds.Cabinet_Close));
    public static final Block Birch_Stool = FurnishBlocks.register("birch_stool", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_), Chair.BASE_SHAPES));
    public static final Block Birch_Chair = FurnishBlocks.register("birch_chair", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_), VoxelShapeHelper.getMergedShapes(Chair.BASE_SHAPES, Chair.CHAIR_SEAT)));
    public static final Block Birch_Shutter = FurnishBlocks.register("birch_shutter", (Block)new Shutter(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50218_)));
    public static final Block Birch_Crate = FurnishBlocks.register("birch_crate", new Crate(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_)));
    public static final Block Birch_Shelf = FurnishBlocks.register("birch_shelf", (Block)new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_)));
    public static final Block Acacia_Table = FurnishBlocks.register("acacia_table", new Table(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_)));
    public static final Block Acacia_Square_Table = FurnishBlocks.register("acacia_square_table", (Block)new SimpleFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_)));
    public static final Block Acacia_Bedside_Table = FurnishBlocks.register("acacia_bedside_table", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Acacia_Kitchen_Cabinet = FurnishBlocks.register("acacia_kitchen_cabinet", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Acacia_Cabinet = FurnishBlocks.register("acacia_cabinet", (Block)new Cabinet(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_), FurnishData.Sounds.Cabinet_Open, FurnishData.Sounds.Cabinet_Close));
    public static final Block Acacia_Wardrobe = FurnishBlocks.register("acacia_wardrobe", (Block)new Wardrobe(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_), FurnishData.Sounds.Cabinet_Open, FurnishData.Sounds.Cabinet_Close));
    public static final Block Acacia_Stool = FurnishBlocks.register("acacia_stool", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_), Chair.BASE_SHAPES));
    public static final Block Acacia_Chair = FurnishBlocks.register("acacia_chair", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_), VoxelShapeHelper.getMergedShapes(Chair.BASE_SHAPES, Chair.CHAIR_TALL_SEAT)));
    public static final Block Acacia_Shutter = FurnishBlocks.register("acacia_shutter", (Block)new Shutter(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50220_)));
    public static final Block Acacia_Crate = FurnishBlocks.register("acacia_crate", new Crate(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_)));
    public static final Block Acacia_Shelf = FurnishBlocks.register("acacia_shelf", (Block)new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_)));
    public static final Block Jungle_Table = FurnishBlocks.register("jungle_table", new Table(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_)));
    public static final Block Jungle_Square_Table = FurnishBlocks.register("jungle_square_table", (Block)new SimpleFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_)));
    public static final Block Jungle_Bedside_Table = FurnishBlocks.register("jungle_bedside_table", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Jungle_Kitchen_Cabinet = FurnishBlocks.register("jungle_kitchen_cabinet", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Jungle_Cabinet = FurnishBlocks.register("jungle_cabinet", (Block)new Cabinet(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_), FurnishData.Sounds.Cabinet_Open, FurnishData.Sounds.Cabinet_Close));
    public static final Block Jungle_Wardrobe = FurnishBlocks.register("jungle_wardrobe", (Block)new Wardrobe(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_), FurnishData.Sounds.Cabinet_Open, FurnishData.Sounds.Cabinet_Close));
    public static final Block Jungle_Stool = FurnishBlocks.register("jungle_stool", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_), Chair.BASE_SHAPES));
    public static final Block Jungle_Chair = FurnishBlocks.register("jungle_chair", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_), VoxelShapeHelper.getMergedShapes(Chair.BASE_SHAPES, Chair.CHAIR_SEAT)));
    public static final Block Jungle_Shutter = FurnishBlocks.register("jungle_shutter", (Block)new Shutter(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50219_)));
    public static final Block Jungle_Crate = FurnishBlocks.register("jungle_crate", new Crate(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_)));
    public static final Block Jungle_Shelf = FurnishBlocks.register("jungle_shelf", (Block)new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_)));
    public static final Block Spruce_Table = FurnishBlocks.register("spruce_table", new Table(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_)));
    public static final Block Spruce_Square_Table = FurnishBlocks.register("spruce_square_table", (Block)new SimpleFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_)));
    public static final Block Spruce_Bedside_Table = FurnishBlocks.register("spruce_bedside_table", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Spruce_Kitchen_Cabinet = FurnishBlocks.register("spruce_kitchen_cabinet", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Spruce_Cabinet = FurnishBlocks.register("spruce_cabinet", (Block)new Cabinet(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_), FurnishData.Sounds.Spruce_Cabinet_Open, FurnishData.Sounds.Spruce_Cabinet_Close));
    public static final Block Spruce_Wardrobe = FurnishBlocks.register("spruce_wardrobe", (Block)new Wardrobe(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_), FurnishData.Sounds.Spruce_Cabinet_Open, FurnishData.Sounds.Spruce_Cabinet_Close));
    public static final Block Spruce_Stool = FurnishBlocks.register("spruce_stool", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_), Chair.BASE_SHAPES));
    public static final Block Spruce_Chair = FurnishBlocks.register("spruce_chair", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_), VoxelShapeHelper.getMergedShapes(Chair.BASE_SHAPES, Chair.CHAIR_TALL_SEAT)));
    public static final Block Spruce_Shutter = FurnishBlocks.register("spruce_shutter", (Block)new Shutter(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50217_)));
    public static final Block Spruce_Crate = FurnishBlocks.register("spruce_crate", new Crate(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_)));
    public static final Block Spruce_Shelf = FurnishBlocks.register("spruce_shelf", (Block)new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_)));
    public static final Block Dark_Oak_Table = FurnishBlocks.register("dark_oak_table", new Table(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_)));
    public static final Block Dark_Oak_Square_Table = FurnishBlocks.register("dark_oak_square_table", (Block)new SimpleFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_)));
    public static final Block Dark_Oak_Bedside_Table = FurnishBlocks.register("dark_oak_bedside_table", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Dark_Oak_Kitchen_Cabinet = FurnishBlocks.register("dark_oak_kitchen_cabinet", (Block)new InventoryFurniture(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_), FurnishData.Sounds.Drawers_Open, FurnishData.Sounds.Drawers_Close));
    public static final Block Dark_Oak_Cabinet = FurnishBlocks.register("dark_oak_cabinet", (Block)new Cabinet(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_), FurnishData.Sounds.Spruce_Cabinet_Open, FurnishData.Sounds.Spruce_Cabinet_Close));
    public static final Block Dark_Oak_Wardrobe = FurnishBlocks.register("dark_oak_wardrobe", (Block)new Wardrobe(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_), FurnishData.Sounds.Spruce_Cabinet_Open, FurnishData.Sounds.Spruce_Cabinet_Close));
    public static final Block Dark_Oak_Stool = FurnishBlocks.register("dark_oak_stool", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_), Chair.BASE_SHAPES));
    public static final Block Dark_Oak_Chair = FurnishBlocks.register("dark_oak_chair", (Block)new Chair(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_), VoxelShapeHelper.getMergedShapes(Chair.BASE_SHAPES, Chair.CHAIR_SEAT_THRONE)));
    public static final Block Dark_Oak_Shutter = FurnishBlocks.register("dark_oak_shutter", (Block)new Shutter(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50221_)));
    public static final Block Dark_Oak_Crate = FurnishBlocks.register("dark_oak_crate", new Crate(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_)));
    public static final Block Dark_Oak_Shelf = FurnishBlocks.register("dark_oak_shelf", (Block)new Shelf(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_)));
    public static final Block Red_Bunting = FurnishBlocks.register("red_bunting", new Bunting(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50267_)));
    public static final Block Yellow_Bunting = FurnishBlocks.register("yellow_bunting", new Bunting(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50267_)));
    public static final Block Green_Bunting = FurnishBlocks.register("green_bunting", new Bunting(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50267_)));
    public static final Block Lantern_Bunting = FurnishBlocks.register("lantern_bunting", new LanternBunting(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.0f).m_60918_(SoundType.f_56762_).m_60953_(state -> 15)));
    public static final Block Soul_Lantern_Bunting = FurnishBlocks.register("soul_lantern_bunting", new LanternBunting(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.0f).m_60918_(SoundType.f_56762_).m_60953_(state -> 10)));
    public static final Block Metal_Mailbox = FurnishBlocks.register("metal_mailbox", (Block)new Mailbox(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60955_().m_60978_(2.0f).m_60918_(SoundType.f_56743_)));
    public static final Block Brick_Chimney_Conduit = FurnishBlocks.register("brick_chimney_conduit", new ChimneyConduit(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(1.0f, 3.0f)));
    public static final Block Brick_Chimney_Cap = FurnishBlocks.register("chimney_cap", new ChimneyCap(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56762_).m_60978_(2.0f)));
    public static final Block Disk_Rack = FurnishBlocks.register("disk_rack", (Block)new DiskRack(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_)));
    public static final Block Paper_Lamp = FurnishBlocks.register("paper_lamp", new PaperLamp());
    public static final Block Red_Paper_Lamp = FurnishBlocks.register("red_paper_lamp", new PaperLamp());
    public static final Block Heavy_Metal = FurnishBlocks.register("heavy_metal", new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60999_().m_60913_(4.0f, 8.0f)));
    public static Block[] FurnitureInvProvider = new Block[]{Oak_Bedside_Table, Oak_Kitchen_Cabinet, Oak_Cabinet, Birch_Bedside_Table, Birch_Kitchen_Cabinet, Birch_Cabinet, Spruce_Bedside_Table, Spruce_Kitchen_Cabinet, Spruce_Cabinet, Jungle_Bedside_Table, Jungle_Kitchen_Cabinet, Jungle_Cabinet, Acacia_Bedside_Table, Acacia_Kitchen_Cabinet, Acacia_Cabinet, Dark_Oak_Bedside_Table, Dark_Oak_Kitchen_Cabinet, Dark_Oak_Cabinet};
    public static Block[] FurnitureLargeInvProvider = new Block[]{Oak_Wardrobe, Birch_Wardrobe, Spruce_Wardrobe, Jungle_Wardrobe, Acacia_Wardrobe, Dark_Oak_Wardrobe};
    public static Block[] Shelves = new Block[]{Oak_Shelf, Birch_Shelf, Spruce_Shelf, Jungle_Shelf, Acacia_Shelf, Dark_Oak_Shelf};
    public static Block[] Disk_Racks = new Block[]{Disk_Rack};
    public static final String[] Rare_Plates_Names = new String[]{"chinese", "english"};
    public static HashMap<String, Block> Carpets_On_Stairs = new HashMap(16);
    public static HashMap<String, Block> Carpets_On_Trapdoors = new HashMap(16);
    public static Block[] Amphorae = new Block[17];
    public static Block[] Sofas = new Block[16];
    public static Block[] Awnings = new Block[16];
    public static Block[] Curtains = new Block[16];
    public static Block[] Plates = new Block[17 + Rare_Plates_Names.length];
    public static Block[] Showcases = new Block[16];

    public static void setup(IEventBus bus) {
        FurnishBlocks.Amphorae[0] = FurnishBlocks.register("amphora", (Block)new Amphora(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50352_)));
        FurnishBlocks.Plates[0] = FurnishBlocks.register("plate", (Block)new Plate(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50352_)));
        int index = 0;
        for (DyeColor dyeColor : DyeColor.values()) {
            String color = dyeColor.m_41065_();
            Block coloredCarpet = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(String.format("minecraft:%s_carpet", color)));
            Carpets_On_Stairs.put(color, FurnishBlocks.register(String.format("%s_carpet_on_stairs", color), (Block)new CarpetOnStairs(BlockBehaviour.Properties.m_60926_((BlockBehaviour)coloredCarpet).m_60916_(coloredCarpet), coloredCarpet)));
            Carpets_On_Trapdoors.put(color, FurnishBlocks.register(String.format("%s_carpet_on_trapdoor", color), (Block)new CarpetOnTrapdoor(BlockBehaviour.Properties.m_60926_((BlockBehaviour)coloredCarpet).m_60916_(coloredCarpet), coloredCarpet)));
            FurnishBlocks.Awnings[index] = FurnishBlocks.register(String.format("%s_awning", color), (Block)new Awning(BlockBehaviour.Properties.m_60926_((BlockBehaviour)coloredCarpet)));
            FurnishBlocks.Curtains[index] = FurnishBlocks.register(String.format("%s_curtain", color), (Block)new Curtain(BlockBehaviour.Properties.m_60926_((BlockBehaviour)coloredCarpet)));
            Block coloredWool = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(String.format("minecraft:%s_wool", color)));
            FurnishBlocks.Sofas[index] = FurnishBlocks.register(String.format("%s_sofa", color), (Block)new Sofa(BlockBehaviour.Properties.m_60926_((BlockBehaviour)coloredWool)));
            FurnishBlocks.Showcases[index] = FurnishBlocks.register(String.format("%s_showcase", color), (Block)new Showcase(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)));
            Block coloredTerracotta = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(String.format("minecraft:%s_terracotta", color)));
            FurnishBlocks.Amphorae[index + 1] = FurnishBlocks.register(String.format("%s_amphora", color), (Block)new Amphora(BlockBehaviour.Properties.m_60926_((BlockBehaviour)coloredTerracotta)));
            FurnishBlocks.Plates[index + 1] = FurnishBlocks.register(String.format("%s_plate", color), (Block)new Plate(BlockBehaviour.Properties.m_60926_((BlockBehaviour)coloredTerracotta)));
            ++index;
        }
        int plateIndex = index;
        for (String s : Rare_Plates_Names) {
            FurnishBlocks.Plates[plateIndex + 1] = FurnishBlocks.register(String.format("rare_%s_plate", s), (Block)new Plate(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50352_)));
            ++plateIndex;
        }
        Registry.register(bus);
    }

    public static void clientSetup() {
        ItemBlockRenderTypes.setRenderLayer((Block)Red_Bunting, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)Yellow_Bunting, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)Green_Bunting, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)Jungle_Shutter, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)Acacia_Shutter, (RenderType)RenderType.m_110466_());
        for (Block b : Showcases) {
            ItemBlockRenderTypes.setRenderLayer((Block)b, (RenderType)RenderType.m_110466_());
        }
    }

    private static Block register(String registryName, Block block) {
        Registry.register(registryName, () -> block);
        return block;
    }

    public static class CustomProperties {
        public static final BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");
    }
}

