/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.gearoftheancients.ability.abilities;

import com.coldspell.gearoftheancients.ability.Abilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class ButcheringAbility {
    public static void kill(LivingDeathEvent event) {
        Player player;
        ItemStack stack;
        CompoundTag tag;
        int abilityLevel;
        LivingEntity target = event.getEntityLiving();
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof Player && (abilityLevel = (tag = (stack = (player = (Player)attacker).m_21205_()).m_41784_()).m_128451_(Abilities.BUTCHERING.getTag())) > 0 && player.m_21187_().nextFloat() <= 0.1f * (float)abilityLevel) {
            ButcheringAbility.dropDeathLootOnPlayerKill(target, player);
        }
    }

    public static void dropDeathLootOnPlayerKill(LivingEntity livingEntity, Player player) {
        Collection drops;
        DamageSource damageSource = DamageSource.m_19344_((Player)player);
        int i = ForgeHooks.getLootingLevel((Entity)livingEntity, (Entity)player, (DamageSource)damageSource);
        livingEntity.captureDrops(new ArrayList());
        if (!livingEntity.m_6162_() && livingEntity.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            ButcheringAbility.dropFromLootTable(livingEntity, player, damageSource);
        }
        if (!ForgeHooks.onLivingDrops((LivingEntity)livingEntity, (DamageSource)damageSource, (Collection)(drops = livingEntity.captureDrops(null)), (int)i, (boolean)true)) {
            drops.forEach(e -> player.f_19853_.m_7967_((Entity)e));
        }
    }

    private static void dropFromLootTable(LivingEntity livingEntity, Player player, DamageSource damageSource) {
        ResourceLocation resourcelocation = livingEntity.m_5743_();
        LootTable loottable = Objects.requireNonNull(livingEntity.f_19853_.m_142572_()).m_129898_().m_79217_(resourcelocation);
        LootContext.Builder lootcontext$builder = ButcheringAbility.createLootContext(livingEntity, player, damageSource);
        LootContext ctx = lootcontext$builder.m_78975_(LootContextParamSets.f_81415_);
        loottable.m_79129_(ctx).forEach(arg_0 -> ((LivingEntity)livingEntity).m_19983_(arg_0));
    }

    private static LootContext.Builder createLootContext(LivingEntity livingEntity, Player player, DamageSource damageSource) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)livingEntity.f_19853_).m_78977_(livingEntity.m_21187_()).m_78972_(LootContextParams.f_81455_, (Object)livingEntity).m_78972_(LootContextParams.f_81460_, (Object)livingEntity.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)damageSource).m_78984_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_78984_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
        lootcontext$builder = lootcontext$builder.m_78972_(LootContextParams.f_81456_, (Object)player).m_78963_(player.m_36336_());
        return lootcontext$builder;
    }
}

