/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.gearoftheancients.item.items;

import com.coldspell.gearoftheancients.ability.Abilities;
import com.coldspell.gearoftheancients.ability.Ability;
import com.coldspell.gearoftheancients.ability.AbilityEventHandler;
import com.coldspell.gearoftheancients.ability.AbilityHelper;
import com.coldspell.gearoftheancients.util.ConfigHandler;
import com.coldspell.gearoftheancients.util.ItemNameHandler;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AncientWeapon
extends SwordItem {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private static final String NBT_COLOR_BASE = "basecolor";
    private static final String NBT_COLOR_OVERLAY = "overcolor";
    private static final Random random = new Random();
    protected static final UUID BASE_ATTACK_RANGE_UUID = UUID.fromString("b15d14d1-033c-4bc1-a20a-a7e06ae86863");

    public AncientWeapon(Tier tier, int damage, float speed, float weaponRange, Item.Properties properties) {
        super(tier, damage, speed, properties);
        float attackDamage = (float)damage + tier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)speed, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> componentList, @NotNull TooltipFlag tooltipFlag) {
        CompoundTag tag = itemStack.m_41784_();
        Ability ability1 = Abilities.matchAbilityToString(tag.m_128461_("ability1"));
        Ability ability2 = Abilities.matchAbilityToString(tag.m_128461_("ability2"));
        Ability ability3 = Abilities.matchAbilityToString(tag.m_128461_("ability3"));
        Ability ability4 = Abilities.matchAbilityToString(tag.m_128461_("ability4"));
        if (!Screen.m_96638_() && tag.m_128471_("set")) {
            componentList.add((Component)new TranslatableComponent("tips.gearoftheancients.type").m_7220_((Component)new TranslatableComponent(itemStack.m_41720_().m_5524_()).m_130940_(ChatFormatting.GRAY)));
        }
        if (ability1 != null) {
            if (!Screen.m_96638_()) {
                componentList.add(AbilityHelper.getAbilityName(itemStack, ability1, ChatFormatting.GREEN));
            } else {
                componentList.add((Component)new TranslatableComponent(AbilityHelper.getAbilityDisc(ability1)).m_130940_(ChatFormatting.GREEN));
            }
        }
        if (ability2 != null) {
            if (!Screen.m_96638_()) {
                componentList.add(AbilityHelper.getAbilityName(itemStack, ability2, ChatFormatting.BLUE));
            } else {
                componentList.add((Component)new TranslatableComponent(AbilityHelper.getAbilityDisc(ability2)).m_130940_(ChatFormatting.BLUE));
            }
        }
        if (ability3 != null) {
            if (!Screen.m_96638_()) {
                componentList.add(AbilityHelper.getAbilityName(itemStack, ability3, ChatFormatting.GOLD));
            } else {
                componentList.add((Component)new TranslatableComponent(AbilityHelper.getAbilityDisc(ability3)).m_130940_(ChatFormatting.GOLD));
            }
        }
        if (ability4 != null) {
            if (!Screen.m_96638_()) {
                componentList.add(AbilityHelper.getAbilityName(itemStack, ability4, ChatFormatting.LIGHT_PURPLE));
            } else {
                componentList.add((Component)new TranslatableComponent(AbilityHelper.getAbilityDisc(ability4)).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
        }
        if (!Screen.m_96638_()) {
            componentList.add((Component)new TranslatableComponent("tips.gearoftheancients.holdshift").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(itemStack, level, componentList, tooltipFlag);
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        if (!level.f_46443_) {
            CompoundTag tag = itemStack.m_41784_();
            this.setWeaponAbilitiesAndColor(tag, itemStack);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AbilityEventHandler.inventoryTicks(player.m_21205_(), level, entity, p_41407_, p_41408_);
        }
        super.m_6883_(itemStack, level, entity, p_41407_, p_41408_);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        AbilityEventHandler.use(level, player, hand);
        return super.m_7203_(level, player, hand);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity attacker, LivingEntity target) {
        AbilityEventHandler.attack(itemStack, attacker, target);
        return super.m_7579_(itemStack, attacker, target);
    }

    public void setWeaponAbilitiesAndColor(CompoundTag tag, ItemStack itemStack) {
        if (!tag.m_128471_("set")) {
            AbilityHelper.setRandomAbilities(itemStack);
            AncientWeapon.setGearColor(itemStack);
            ItemNameHandler.renameItemStack(itemStack);
            tag.m_128379_("set", true);
        }
    }

    public void randomizeWeaponDamage() {
    }

    public static int getBaseColor(ItemStack stack) {
        return stack.m_41784_().m_128451_(NBT_COLOR_BASE);
    }

    public static int getOverlayColor(ItemStack stack) {
        return stack.m_41784_().m_128451_(NBT_COLOR_OVERLAY);
    }

    public static void setGearColor(ItemStack stack) {
        stack.m_41784_().m_128405_(NBT_COLOR_BASE, random.nextInt(10511680));
        stack.m_41784_().m_128405_(NBT_COLOR_OVERLAY, random.nextInt(10511680));
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return AncientWeapon.getBaseColor(stack);
        }
        return AncientWeapon.getOverlayColor(stack);
    }

    public boolean m_41475_() {
        return (Boolean)ConfigHandler.SETTINGS.fireproof.get();
    }
}

