/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.gearoftheancients.util;

import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;

public class ItemNameHandler {
    private static final Random random = new Random();
    private static final List<String> CHARACTER_LIST = List.of("Knight", "Dragon", "Ancient", "Champion", "Wizard", "Zombie", "Creeper", "Skeleton", "Bat", "Wolf", "Wither", "Husk", "Enderman", "Ghast", "Piglin", "Pillager", "Ravenger", "Hoglin", "Vex", "Ghost", "Warlord", "Warden", "Phantom", "Spider", "Cave Spider", "Stray", "Slime", "Witch", "Guardian", "Blaze", "Forsaken", "Wretched", "Paragon", "Foe", "World", "Giant", "Death", "Life", "Thief", "Scout", "Void", "Spirit", "Storm", "Sleepwalker", "Sky", "Widow", "Winter", "Summer", "Spring", "Autumn", "Night", "Morning", "Dusk", "Sunrise", "Slayer", "Reaper", "Beacon", "Wanderer", "Traitor", "Immortal", "Mortal", "Executioner", "Faded", "North", "East", "West", "South", "Grave", "Voice", "Nether", "End", "Sun", "Moon", "Sky", "Desert", "Forest", "Ancient Temple", "Ghost Walker", "Haunter", "Banshee", "Feline", "Crow", "Eagle", "Hawk", "Villager", "Ocelot", "Strider", "Allay", "Golem", "Pigman", "Evoker", "Vindicator", "Drowned", "Zoglin");
    private static final List<String> SECOND_NAME_LIST = List.of("Bane", "Aspect", "Song", "Mercy", "Torment", "Chaos", "Nature", "Flame", "Thunder", "Spark", "Corruption", "Destruction", "Eclipse", "Echo", "Riddle", "Touch", "Secret", "Insanity", "Torrent", "Shard", "Focus", "Persuasion", "Dawn", "Memory", "Power", "JuJu", "Charge", "Grace", "Idol", "Pledge", "Thorn", "Whisper", "Faith", "Reaver", "Fall", "Twisted Vision", "Breaker", "Carver", "Nightmare", "Enigma", "Retribution", "Soul", "Damnation", "Striker", "Fury", "Hysteria", "Visage", "Renderer", "Guard", "Binder", "Harmony", "Glimmer", "Clarity", "Malice", "Etcher", "Legacy", "Maker", "Crafter", "Reckoning", "Bone", "Essence", "Weaver", "Ritual", "Omen", "Cunning", "Brilliance", "Remorse", "Plague", "Defender", "Annihilation", "Kiss", "Magic", "Glory", "Burden", "Broken Dreams", "Lost Wishes", "Dark Memories", "Favor", "Grievance", "Pact", "Loyalty", "Reach", "Heirloom", "Lost Hope");

    public static void renameItemStack(ItemStack itemStack) {
        String name = ItemNameHandler.getGeneratedName(itemStack);
        itemStack.m_41714_((Component)new TranslatableComponent(name));
    }

    public static String getGeneratedName(ItemStack itemStack) {
        float i = random.nextFloat();
        String name = i < 0.8f ? ItemNameHandler.getCharacterName() : ItemNameHandler.getCharacterPlusWeaponName(itemStack);
        return name;
    }

    private static String getCharacterName() {
        String name = random.nextBoolean() ? ItemNameHandler.getRandomCharacterName() + "'s " + ItemNameHandler.getRandomSecondName() : ItemNameHandler.getRandomSecondName() + " of the " + ItemNameHandler.getRandomCharacterName();
        return name;
    }

    private static String getCharacterPlusWeaponName(ItemStack itemStack) {
        String weapon = itemStack.m_41720_().m_41466_().getString();
        int i = random.nextInt(3);
        String name = i == 0 ? ItemNameHandler.getRandomCharacterName() + "'s " + weapon : (i == 1 ? weapon + " of the " + ItemNameHandler.getRandomCharacterName() : ItemNameHandler.getRandomCharacterName() + "'s " + weapon + " of " + ItemNameHandler.getRandomSecondName());
        return name;
    }

    private static String getRandomCharacterName() {
        int count = CHARACTER_LIST.size();
        return CHARACTER_LIST.get(random.nextInt(count));
    }

    private static String getRandomSecondName() {
        int count = SECOND_NAME_LIST.size();
        return SECOND_NAME_LIST.get(random.nextInt(count));
    }
}

