/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.gearoftheancients.ability;

import com.coldspell.gearoftheancients.ability.Abilities;
import com.coldspell.gearoftheancients.ability.Ability;
import com.coldspell.gearoftheancients.item.items.IncreaseAbilityItem;
import com.coldspell.gearoftheancients.util.ConfigHandler;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AbilityHelper {
    private static final Random random = new Random();
    private static final String ABILITY1 = "ability1";
    private static final String ABILITY2 = "ability2";
    private static final String ABILITY3 = "ability3";
    private static final String ABILITY4 = "ability4";

    public static Component getAbilityName(ItemStack itemStack, Ability ability, ChatFormatting color) {
        return Component.m_237115_((String)("ability.gearoftheancients." + ability.getTag())).m_130940_(color).m_130946_(AbilityHelper.getAbilityLevel(itemStack, ability));
    }

    public static String getAbilityDisc(Ability ability) {
        return "ability.gearoftheancients." + ability.getTag() + ".disc";
    }

    public static String getAbilityLevel(ItemStack itemStack, Ability ability) {
        CompoundTag tag = itemStack.m_41784_();
        int i = tag.m_128451_(ability.getTag());
        return switch (i) {
            case 2 -> " II";
            case 3 -> " III";
            case 4 -> " IV";
            case 5 -> " V";
            case 6 -> " VI";
            case 7 -> " VII";
            case 8 -> " VIII";
            case 9 -> " IX";
            case 10 -> " X";
            default -> "";
        };
    }

    public static void setRandomAbilities(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        Ability ability1 = AbilityHelper.getGreenAbility((float)((Integer)ConfigHandler.SETTINGS.greenChance.get()).intValue() * 0.01f);
        Ability ability2 = AbilityHelper.getBlueAbility((float)((Integer)ConfigHandler.SETTINGS.blueChance.get()).intValue() * 0.01f);
        Ability ability3 = AbilityHelper.getGoldAbility((float)((Integer)ConfigHandler.SETTINGS.goldChance.get()).intValue() * 0.01f);
        Ability ability4 = AbilityHelper.getPurpleAbility((float)((Integer)ConfigHandler.SETTINGS.purpleChance.get()).intValue() * 0.01f);
        if (ability1 != null) {
            tag.m_128359_(ABILITY1, ability1.getTag());
            tag.m_128405_(ability1.getTag(), 1);
        }
        if (ability2 != null) {
            tag.m_128359_(ABILITY2, ability2.getTag());
            tag.m_128405_(ability2.getTag(), 1);
        }
        if (ability3 != null) {
            tag.m_128359_(ABILITY3, ability3.getTag());
            tag.m_128405_(ability3.getTag(), 1);
        }
        if (ability4 != null) {
            tag.m_128359_(ABILITY4, ability4.getTag());
            tag.m_128405_(ability4.getTag(), 1);
        }
    }

    public static void rerollAbility(ItemStack itemStack, String abilitySlot) {
        CompoundTag tag = itemStack.m_41784_();
        Ability ability = null;
        if (Objects.equals(abilitySlot, ABILITY1)) {
            ability = AbilityHelper.getGreenAbility(1.0f);
        }
        if (Objects.equals(abilitySlot, ABILITY2)) {
            ability = AbilityHelper.getBlueAbility(1.0f);
        }
        if (Objects.equals(abilitySlot, ABILITY3)) {
            ability = AbilityHelper.getGoldAbility(1.0f);
        }
        if (Objects.equals(abilitySlot, ABILITY4)) {
            ability = AbilityHelper.getPurpleAbility(1.0f);
        }
        if (ability != null) {
            tag.m_128405_(tag.m_128461_(abilitySlot), 0);
            tag.m_128359_(abilitySlot, ability.getTag());
            tag.m_128405_(ability.getTag(), 1);
        }
    }

    public static int getAbilityScore(CompoundTag tag) {
        int a1 = AbilityHelper.getScorePerAbility(tag, ABILITY1);
        int a2 = AbilityHelper.getScorePerAbility(tag, ABILITY2);
        int a3 = AbilityHelper.getScorePerAbility(tag, ABILITY3);
        int a4 = AbilityHelper.getScorePerAbility(tag, ABILITY4);
        return a1 + a2 + a3 + a4;
    }

    private static int getScorePerAbility(CompoundTag tag, String abilitySlot) {
        Ability ability = Abilities.matchAbilityToString(tag.m_128461_(abilitySlot));
        int i = ability != null ? tag.m_128451_(ability.getTag()) * ability.getScore() : 0;
        return i;
    }

    public static void increaseAbility(Player player, CompoundTag tag, String abilitySlot) {
        if (tag.m_128441_(abilitySlot)) {
            Ability ability = Abilities.matchAbilityToString(tag.m_128461_(abilitySlot));
            if (ability != null && !player.f_19853_.f_46443_) {
                int max = ability.getMaxLevel();
                int currentLevel = tag.m_128451_(ability.getTag());
                if (currentLevel < max) {
                    tag.m_128405_(ability.getTag(), currentLevel + 1);
                    if (abilitySlot.equals(ABILITY1)) {
                        player.m_213846_((Component)Component.m_237115_((String)"gains.gearoftheancients.levelup").m_130940_(ChatFormatting.GREEN));
                    }
                    if (abilitySlot.equals(ABILITY2)) {
                        player.m_213846_((Component)Component.m_237115_((String)"gains.gearoftheancients.levelup").m_130940_(ChatFormatting.BLUE));
                    }
                    if (abilitySlot.equals(ABILITY3)) {
                        player.m_213846_((Component)Component.m_237115_((String)"gains.gearoftheancients.levelup").m_130940_(ChatFormatting.GOLD));
                    }
                    if (abilitySlot.equals(ABILITY4)) {
                        player.m_213846_((Component)Component.m_237115_((String)"gains.gearoftheancients.levelup").m_130940_(ChatFormatting.LIGHT_PURPLE));
                    }
                    player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12436_, SoundSource.AMBIENT, 1.0f, 1.0f);
                    if (!player.m_7500_() && player.m_21205_().m_41720_() instanceof IncreaseAbilityItem) {
                        player.m_21205_().m_41774_(1);
                    }
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"gains.gearoftheancients.noLevel").m_130940_(ChatFormatting.RED));
                }
            }
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"gains.gearoftheancients.noslot").m_130940_(ChatFormatting.RED));
        }
    }

    public static Ability getGreenAbility(float chance) {
        Ability ability = null;
        if (random.nextFloat() <= chance) {
            int i = Abilities.GREEN_ABILITIES.size();
            ability = Abilities.GREEN_ABILITIES.get(random.nextInt(i));
        }
        return ability;
    }

    public static Ability getBlueAbility(float chance) {
        Ability ability = null;
        if (random.nextFloat() <= chance) {
            int i = Abilities.BLUE_ABILITIES.size();
            ability = Abilities.BLUE_ABILITIES.get(random.nextInt(i));
        }
        return ability;
    }

    public static Ability getGoldAbility(float chance) {
        Ability ability = null;
        if (random.nextFloat() <= chance) {
            int i = Abilities.GOLD_ABILITIES.size();
            ability = Abilities.GOLD_ABILITIES.get(random.nextInt(i));
        }
        return ability;
    }

    public static Ability getPurpleAbility(float chance) {
        Ability ability = null;
        if (random.nextFloat() <= chance) {
            int i = Abilities.PURPLE_ABILITIES.size();
            ability = Abilities.PURPLE_ABILITIES.get(random.nextInt(i));
        }
        return ability;
    }
}

