/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.gearoftheancients.ability.abilities;

import com.coldspell.gearoftheancients.ability.Abilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;

public class VoidStepAbility {
    public static void tick(ItemStack stack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        CompoundTag tag = stack.m_41784_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int abilityLevel = tag.m_128451_(Abilities.VOID_STEP.getTag());
            if (abilityLevel > 0) {
                VoidStepAbility.voidstep(player, tag);
            }
        }
    }

    private static void voidstep(Player player, CompoundTag tag) {
        Level level = player.f_19853_;
        if (level.m_46472_() == Level.f_46430_) {
            BlockPos pos = player.m_20183_();
            VoidStepAbility.setSafety(tag, player);
            if (pos.m_123342_() <= -10) {
                VoidStepAbility.teleportToSafePos(player, tag);
            }
        }
    }

    private static boolean canSupport(LevelReader levelReader, BlockPos pos, Direction direction) {
        BlockState blockstate = levelReader.m_8055_(pos);
        return (direction != Direction.UP || !blockstate.m_204336_(BlockTags.f_13056_)) && blockstate.m_60659_((BlockGetter)levelReader, pos, direction, SupportType.FULL);
    }

    private static void setSafety(CompoundTag tag, Player player) {
        Level level = player.f_19853_;
        BlockPos pos = player.m_20183_().m_7495_();
        if (VoidStepAbility.canSupport((LevelReader)level, pos, Direction.UP)) {
            tag.m_128347_("posX", (double)pos.m_123341_());
            tag.m_128347_("posY", (double)pos.m_123342_());
            tag.m_128347_("posZ", (double)pos.m_123343_());
        }
    }

    private static void teleportToSafePos(Player player, CompoundTag tag) {
        Level level = player.f_19853_;
        BlockPos pos = player.m_20183_().m_7495_();
        if (!VoidStepAbility.canSupport((LevelReader)level, pos, Direction.UP)) {
            double posX = tag.m_128459_("posX");
            double posY = tag.m_128459_("posY") + 1.0;
            double posZ = tag.m_128459_("posZ");
            player.f_19789_ = 0.0f;
            player.m_6021_(posX + 0.5, posY, posZ + 0.5);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.AMBIENT, 1.5f, 0.4f / (player.m_217043_().m_188501_() * 0.4f + 0.8f));
            if (!player.m_150110_().f_35937_) {
                player.m_6469_(DamageSource.f_19315_, 2.0f);
            }
        }
    }
}

