/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag;

import com.github.mechalopa.hmag.HMaG;
import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.entity.IModMob;
import com.github.mechalopa.hmag.entity.KashaEntity;
import com.github.mechalopa.hmag.item.ModArmorMaterial;
import com.github.mechalopa.hmag.registry.ModEffects;
import com.github.mechalopa.hmag.registry.ModEnchantments;
import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.registry.ModItems;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.util.ModUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="hmag", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    private static final UUID[] HEALTH_BOOST_ENCHANTMENT_MAX_HEALTH_UUIDS = new UUID[]{UUID.fromString("EB931A99-0CF2-6E81-DC0C-9DC22573CCDA"), UUID.fromString("16515E9A-B529-151F-EF1E-FA0B55CB3044"), UUID.fromString("F31C89C1-E8F7-EFED-89E4-8C14E796C09A"), UUID.fromString("036BEDC4-2459-9224-5E89-909F95F799EB")};
    private static final UUID[] NECROTIC_CHAINMAIL_ARMOR_ATTACK_SPEED_UUIDS = new UUID[]{UUID.fromString("81D1E394-8B33-AC3D-325A-C8A03E757B51"), UUID.fromString("B4EFB0CA-2180-0043-0FF9-BE033CC510D5"), UUID.fromString("7FD9FBE7-0438-BF0F-F901-F961384F9591"), UUID.fromString("28E5C0B5-109B-339B-BE83-610B5B399256")};
    private static final UUID INSOMNIA_SWORD_ATTACK_DAMAGE_UUID = UUID.fromString("04C38766-C1A5-31D4-410B-C6B4BE3B7DD2");
    private static final UUID NEMESIS_BLADE_ATTACK_DAMAGE_UUID = UUID.fromString("FD835C41-1211-AC72-0CD4-66F3061FB156");
    private static final UUID NEMESIS_BLADE_ATTACK_SPEED_UUID = UUID.fromString("1911699B-779B-820E-064A-112D1EB232F7");
    private static final UUID NEMESIS_BLADE_MOVEMENT_SPEED_UUID = UUID.fromString("C80A68DD-F985-4245-4EC4-64884C8EBA4C");
    private static final AttributeModifier NEMESIS_BLADE_MOVEMENT_SPEED_MODIFIER = new AttributeModifier(NEMESIS_BLADE_MOVEMENT_SPEED_UUID, "Nemesis blade move speed penalty", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final UUID ANCIENT_SHIELD_KNOCKBACK_RESISTANCE_UUID = UUID.fromString("0915B1C7-492D-2776-EFF2-436BF1072692");
    private static final AttributeModifier ANCIENT_SHIELD_KNOCKBACK_RESISTANCE_MODIFIER = new AttributeModifier(ANCIENT_SHIELD_KNOCKBACK_RESISTANCE_UUID, "Ancient shield knockback resistance bonus", (double)0.05f, AttributeModifier.Operation.ADDITION);
    private static final ITextComponent INSOMNIA_SWORD_MESSAGE = new TranslationTextComponent("message.hmag.insomnia_sword");

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() != null && event.getSource() != null && !event.getSource().func_76352_a()) {
            int level;
            LivingEntity attacker;
            ItemStack stack;
            LivingEntity livingentity = event.getEntityLiving();
            DamageSource source = event.getSource();
            if (source.func_76346_g() != null && source.func_76346_g() instanceof LivingEntity && !(stack = (attacker = (LivingEntity)source.func_76346_g()).func_184614_ca()).func_190926_b() && stack.func_77942_o() && (level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.WATER_ASPECT.get()), (ItemStack)stack)) > 0) {
                if (livingentity.func_70027_ad()) {
                    livingentity.func_70066_B();
                }
                if (livingentity.func_230270_dK_()) {
                    event.setAmount(event.getAmount() + (float)level * 2.5f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDamage(LivingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() != null && event.getSource() != null && event.getSource().func_76347_k() && !event.getEntityLiving().func_184607_cu().func_190926_b() && event.getEntityLiving().func_184607_cu().func_77973_b() == ModItems.FORTRESS_SHIELD.get()) {
            event.setAmount(event.getAmount() * 0.25f);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() != null && event.getSource() != null) {
            LivingEntity livingentity = event.getEntityLiving();
            DamageSource source = event.getSource();
            if (!livingentity.func_184607_cu().func_190926_b() && source.func_76346_g() != null && source.func_76346_g() instanceof LivingEntity && source.func_76364_f() != null && source.func_76346_g().equals((Object)source.func_76364_f())) {
                if (livingentity.func_184607_cu().func_77973_b() == ModItems.ANCIENT_SHIELD.get()) {
                    if (livingentity.func_70681_au().nextInt(5) == 0) {
                        int i = livingentity.func_70681_au().nextInt(3);
                        ((LivingEntity)source.func_76346_g()).func_195064_c(new EffectInstance(i == 2 ? Effects.field_76437_t : (i == 1 ? Effects.field_76421_d : Effects.field_76419_f), 100, 0));
                    }
                } else if (livingentity.func_184607_cu().func_77973_b() == ModItems.FORTRESS_SHIELD.get() && livingentity.func_70681_au().nextInt(5) == 0) {
                    source.func_76346_g().func_70015_d(8);
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        if (event.getEntityLiving().field_70173_aa == 1 && !event.getEntityLiving().getPersistentData().func_74767_n("hmag.checked")) {
            event.getEntityLiving().getPersistentData().func_74757_a("hmag.checked", true);
            if (event.getEntityLiving() instanceof MobEntity) {
                MobEntity mobentity = (MobEntity)event.getEntityLiving();
                if (mobentity.getPersistentData().func_74767_n("hmag.withSpawnParticle")) {
                    mobentity.func_70656_aK();
                    mobentity.getPersistentData().func_82580_o("hmag.withSpawnParticle");
                }
                if (!(!mobentity.func_70613_aW() || !mobentity.getPersistentData().func_74767_n("hmag.checking") || mobentity.getPersistentData().func_74767_n("hmag.notReplaced") || mobentity.func_104002_bU() || mobentity.func_213392_I() || mobentity.func_184207_aI() || mobentity.func_184218_aH())) {
                    ServerWorld serverworld = (ServerWorld)event.getEntityLiving().func_130014_f_();
                    double d = event.getEntityLiving().func_70681_au().nextDouble();
                    if (ModConfigs.cachedServer.ZOMBIE_GIRL_REPLACE_CHANCE > d && ModTags.checkTagContains(ModTags.ZOMBIE_GIRL_REPLACEABLES, mobentity.func_200600_R())) {
                        ModEvents.replace(serverworld, mobentity, (EntityType)ModEntityTypes.ZOMBIE_GIRL.get());
                    } else if (ModConfigs.cachedServer.HUSK_GIRL_REPLACE_CHANCE > d && ModTags.checkTagContains(ModTags.HUSK_GIRL_REPLACEABLES, mobentity.func_200600_R())) {
                        ModEvents.replace(serverworld, mobentity, (EntityType)ModEntityTypes.HUSK_GIRL.get());
                    } else if (ModConfigs.cachedServer.DROWNED_GIRL_REPLACE_CHANCE > d && ModTags.checkTagContains(ModTags.DROWNED_GIRL_REPLACEABLES, mobentity.func_200600_R())) {
                        ModEvents.replace(serverworld, mobentity, (EntityType)ModEntityTypes.DROWNED_GIRL.get());
                    } else if (ModConfigs.cachedServer.SKELETON_GIRL_REPLACE_CHANCE > d && ModTags.checkTagContains(ModTags.SKELETON_GIRL_REPLACEABLES, mobentity.func_200600_R())) {
                        ModEvents.replace(serverworld, mobentity, (EntityType)ModEntityTypes.SKELETON_GIRL.get());
                    } else if (ModConfigs.cachedServer.WITHER_SKELETON_GIRL_REPLACE_CHANCE > d && ModTags.checkTagContains(ModTags.WITHER_SKELETON_GIRL_REPLACEABLES, mobentity.func_200600_R())) {
                        ModEvents.replace(serverworld, mobentity, (EntityType)ModEntityTypes.WITHER_SKELETON_GIRL.get());
                    } else if (ModConfigs.cachedServer.STRAY_GIRL_REPLACE_CHANCE > d && ModTags.checkTagContains(ModTags.STRAY_GIRL_REPLACEABLES, mobentity.func_200600_R())) {
                        ModEvents.replace(serverworld, mobentity, (EntityType)ModEntityTypes.STRAY_GIRL.get());
                    } else if (ModConfigs.cachedServer.CREEPER_GIRL_REPLACE_CHANCE > d && ModTags.checkTagContains(ModTags.CREEPER_GIRL_REPLACEABLES, mobentity.func_200600_R())) {
                        ModEvents.replace(serverworld, mobentity, (EntityType)ModEntityTypes.CREEPER_GIRL.get());
                    } else if (ModConfigs.cachedServer.ENDER_EXECUTOR_REPLACE_CHANCE > d && ModTags.checkTagContains(ModTags.ENDER_EXECUTOR_REPLACEABLES, mobentity.func_200600_R())) {
                        ModEvents.replace(serverworld, mobentity, (EntityType)ModEntityTypes.ENDER_EXECUTOR.get());
                    }
                }
            }
        }
    }

    private static boolean replace(ServerWorld worldIn, MobEntity mobEntityIn, EntityType<?> type) {
        if (mobEntityIn.func_200600_R().equals(type)) {
            return false;
        }
        MobEntity mobentity = ModEvents.createMob(worldIn, type);
        if (mobentity == null) {
            return false;
        }
        ILivingEntityData ilivingentitydata = null;
        mobentity.func_82149_j((Entity)mobEntityIn);
        ilivingentitydata = mobentity.func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(new BlockPos(mobEntityIn.func_213303_ch())), SpawnReason.NATURAL, ilivingentitydata, (CompoundNBT)null);
        mobentity.func_94061_f(mobEntityIn.func_175446_cd());
        if (mobEntityIn.func_145818_k_()) {
            mobentity.func_200203_b(mobEntityIn.func_200201_e());
            mobentity.func_174805_g(mobEntityIn.func_174833_aM());
        }
        mobentity.getPersistentData().func_74757_a("hmag.notReplaced", true);
        worldIn.func_242417_l((Entity)mobentity);
        mobEntityIn.func_70106_y();
        return true;
    }

    @Nullable
    private static MobEntity createMob(ServerWorld worldIn, EntityType<?> type) {
        try {
            Entity entity = type.func_200721_a((World)worldIn);
            if (!(entity instanceof MobEntity)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + ForgeRegistries.ENTITIES.getKey(type));
            }
            return (MobEntity)entity;
        }
        catch (Exception e) {
            HMaG.LOGGER.warn("Failed to create hmag mob", (Throwable)e);
            return null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.DENY || event.getEntityLiving() == null) {
            return;
        }
        if (event.getEntityLiving() instanceof IModMob && ModUtils.checkDimensionList(event.getEntityLiving().func_130014_f_(), ModConfigs.cachedServer.SPAWN_DIMENSION_BLACKLIST)) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getSpawnReason() == SpawnReason.NATURAL && !ModUtils.checkDimensionList(event.getEntityLiving().func_130014_f_(), ModConfigs.cachedServer.MOB_REPLACE_DIMENSION_BLACKLIST) && !ModUtils.checkBiomeList(event.getEntityLiving().func_130014_f_(), event.getEntityLiving().func_233580_cy_(), ModConfigs.cachedServer.MOB_REPLACE_BIOME_BLACKLIST)) {
            LivingEntity livingentity = event.getEntityLiving();
            if (ModConfigs.cachedServer.ZOMBIE_GIRL_REPLACE_CHANCE > 0.0 && ModTags.checkTagContains(ModTags.ZOMBIE_GIRL_REPLACEABLES, livingentity.func_200600_R())) {
                ModEvents.putCheckingTag(livingentity);
            } else if (ModConfigs.cachedServer.HUSK_GIRL_REPLACE_CHANCE > 0.0 && ModTags.checkTagContains(ModTags.HUSK_GIRL_REPLACEABLES, livingentity.func_200600_R())) {
                ModEvents.putCheckingTag(livingentity);
            } else if (ModConfigs.cachedServer.DROWNED_GIRL_REPLACE_CHANCE > 0.0 && ModTags.checkTagContains(ModTags.DROWNED_GIRL_REPLACEABLES, livingentity.func_200600_R())) {
                ModEvents.putCheckingTag(livingentity);
            } else if (ModConfigs.cachedServer.SKELETON_GIRL_REPLACE_CHANCE > 0.0 && ModTags.checkTagContains(ModTags.SKELETON_GIRL_REPLACEABLES, livingentity.func_200600_R())) {
                ModEvents.putCheckingTag(livingentity);
            } else if (ModConfigs.cachedServer.WITHER_SKELETON_GIRL_REPLACE_CHANCE > 0.0 && ModTags.checkTagContains(ModTags.WITHER_SKELETON_GIRL_REPLACEABLES, livingentity.func_200600_R())) {
                ModEvents.putCheckingTag(livingentity);
            } else if (ModConfigs.cachedServer.STRAY_GIRL_REPLACE_CHANCE > 0.0 && ModTags.checkTagContains(ModTags.STRAY_GIRL_REPLACEABLES, livingentity.func_200600_R())) {
                ModEvents.putCheckingTag(livingentity);
            } else if (ModConfigs.cachedServer.CREEPER_GIRL_REPLACE_CHANCE > 0.0 && ModTags.checkTagContains(ModTags.CREEPER_GIRL_REPLACEABLES, livingentity.func_200600_R())) {
                ModEvents.putCheckingTag(livingentity);
            } else if (ModConfigs.cachedServer.ENDER_EXECUTOR_REPLACE_CHANCE > 0.0 && ModTags.checkTagContains(ModTags.ENDER_EXECUTOR_REPLACEABLES, livingentity.func_200600_R())) {
                ModEvents.putCheckingTag(livingentity);
            }
        }
    }

    private static void putCheckingTag(LivingEntity living) {
        living.getPersistentData().func_74757_a("hmag.checking", true);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        try {
            if (event.getEntity() != null) {
                if (event.getEntity() instanceof EndermanEntity) {
                    EndermanEntity endermanentity = (EndermanEntity)event.getEntity();
                    endermanentity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)endermanentity, LivingEntity.class, 10, false, false, p -> {
                        if (!(p instanceof EndermanEntity) && p.func_70644_a((Effect)ModEffects.ENDER_RAGE.get())) {
                            double d0 = 8.0 + (double)p.func_70660_b((Effect)ModEffects.ENDER_RAGE.get()).func_76458_c() * 12.0;
                            return p.func_70068_e((Entity)endermanentity) <= d0 * d0;
                        }
                        return false;
                    }).func_190882_b(30));
                } else if (event.getEntity() instanceof CreeperEntity) {
                    CreeperEntity creeerentity = (CreeperEntity)event.getEntity();
                    creeerentity.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)creeerentity, KashaEntity.class, 6.0f, 1.0, 1.2));
                }
            }
        }
        catch (Exception e) {
            HMaG.LOGGER.warn("Failed to add goals to mobs", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onPotionApplicable(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntityLiving() != null && event.getPotionEffect() != null) {
            LivingEntity livingentity = event.getEntityLiving();
            Effect effect = event.getPotionEffect().func_188419_a();
            if (effect == Effects.field_76421_d || effect == Effects.field_76419_f || effect == Effects.field_76437_t) {
                int i = 0;
                for (ItemStack stack : livingentity.func_184193_aE()) {
                    Item item;
                    if (stack.func_190926_b() || (item = stack.func_77973_b()) == null || !(item instanceof ArmorItem) || ((ArmorItem)item).func_200880_d() != ModArmorMaterial.ANCIENT) continue;
                    ++i;
                }
                if (ModUtils.matchItemBothHands(livingentity, (Item)ModItems.ANCIENT_SHIELD.get())) {
                    ++i;
                }
                if (i >= 4 || i > event.getPotionEffect().func_76458_c() + 1) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (effect == Effects.field_76440_q) {
                ItemStack stack1;
                if (livingentity instanceof PlayerEntity && !(stack1 = livingentity.func_184614_ca()).func_190926_b() && stack1.func_77973_b() == ModItems.INSOMNIA_SWORD.get() && ModUtils.getLevel(stack1) > 0) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (effect == ModEffects.COMBUSTION.get()) {
                if (livingentity.func_230279_az_() || ModUtils.matchItemBothHands(livingentity, (Item)ModItems.FORTRESS_SHIELD.get())) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (effect == ModEffects.ENDER_RAGE.get() && livingentity instanceof EndermanEntity) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onItemAttributeModifier(ItemAttributeModifierEvent event) {
        if (!event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() != null) {
            ItemStack stack = event.getItemStack();
            if (event.getSlotType() == MobEntity.func_184640_d((ItemStack)stack)) {
                int level;
                int i = event.getSlotType().func_188454_b();
                if (event.getSlotType().func_188453_a() == EquipmentSlotType.Group.ARMOR && i >= 0 && i < HEALTH_BOOST_ENCHANTMENT_MAX_HEALTH_UUIDS.length && (level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.HEALTH_BOOST.get()), (ItemStack)stack)) > 0) {
                    event.addModifier(Attributes.field_233818_a_, new AttributeModifier(HEALTH_BOOST_ENCHANTMENT_MAX_HEALTH_UUIDS[i], "Health boost enchantment " + event.getSlotType().func_188450_d() + " max health bonus", (double)((float)level * 1.0f), AttributeModifier.Operation.ADDITION));
                }
                if (stack.func_77973_b() instanceof ArmorItem && ((ArmorItem)stack.func_77973_b()).func_200880_d() == ModArmorMaterial.NECROTIC_CHAIN) {
                    event.addModifier(Attributes.field_233825_h_, new AttributeModifier(NECROTIC_CHAINMAIL_ARMOR_ATTACK_SPEED_UUIDS[i], "Necrotic chainmail armor " + event.getSlotType().func_188450_d() + " attack speed bonus", (double)0.1f, AttributeModifier.Operation.MULTIPLY_TOTAL));
                } else if (stack.func_77973_b() == ModItems.INSOMNIA_SWORD.get()) {
                    int level1 = ModUtils.getLevel(stack);
                    if (level1 > 0) {
                        event.addModifier(Attributes.field_233823_f_, new AttributeModifier(INSOMNIA_SWORD_ATTACK_DAMAGE_UUID, "Insomnia sword attack damage bonus", (double)((float)level1 * 1.0f + 1.0f), AttributeModifier.Operation.ADDITION));
                    }
                } else if (stack.func_77973_b() == ModItems.NEMESIS_BLADE.get()) {
                    int level2 = ModUtils.getLevel(stack);
                    if (level2 > 0) {
                        event.addModifier(Attributes.field_233823_f_, new AttributeModifier(NEMESIS_BLADE_ATTACK_DAMAGE_UUID, "Nemesis blade attack damage bonus", (double)((float)level2 * 1.0f), AttributeModifier.Operation.ADDITION));
                        event.addModifier(Attributes.field_233825_h_, new AttributeModifier(NEMESIS_BLADE_ATTACK_SPEED_UUID, "Nemesis blade attack speed bonus", (double)((float)level2 * 0.25f), AttributeModifier.Operation.ADDITION));
                    } else {
                        event.addModifier(Attributes.field_233821_d_, NEMESIS_BLADE_MOVEMENT_SPEED_MODIFIER);
                    }
                }
            }
            if (event.getSlotType().func_188453_a() == EquipmentSlotType.Group.HAND && stack.func_77973_b() == ModItems.ANCIENT_SHIELD.get()) {
                event.addModifier(Attributes.field_233820_c_, ANCIENT_SHIELD_KNOCKBACK_RESISTANCE_MODIFIER);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        if (event.getResultStatus() == null && event.getPlayer().field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.INSOMNIA_SWORD.get()))) {
            event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
            event.getPlayer().func_146105_b(INSOMNIA_SWORD_MESSAGE, true);
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntityItem() != null && event.getEntityItem().func_92059_d() != null && !event.getEntityItem().func_92059_d().func_190926_b()) {
            if (event.getEntityItem().func_92059_d().func_77973_b() == ModItems.INSOMNIA_SWORD.get()) {
                ModUtils.removeLevelTag(event.getEntityItem().func_92059_d());
            } else if (event.getEntityItem().func_92059_d().func_77973_b() == ModItems.NEMESIS_BLADE.get()) {
                ModUtils.removeLevelTag(event.getEntityItem().func_92059_d());
            }
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() != null && !(event.getEntityLiving() instanceof PlayerEntity) && event.getTo() != null && !event.getTo().func_190926_b()) {
            if (event.getTo().func_77973_b() == ModItems.INSOMNIA_SWORD.get()) {
                ModUtils.removeLevelTag(event.getTo());
            } else if (event.getTo().func_77973_b() == ModItems.NEMESIS_BLADE.get()) {
                ModUtils.removeLevelTag(event.getTo());
            }
        }
    }

    @SubscribeEvent
    public void onStructureSpawn(StructureSpawnListGatherEvent event) {
        if (ModConfigs.cachedServer.MONOLITH_SPAWN_WEIGHT_IN_END_CITY > 0 && event.getStructure() == Structure.field_236379_o_) {
            event.addEntitySpawn(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)ModEntityTypes.MONOLITH.get(), ModConfigs.cachedServer.MONOLITH_SPAWN_WEIGHT_IN_END_CITY, 1, 1));
        }
        if (ModConfigs.cachedServer.FORTRESS_KEEPER_SPAWN_WEIGHT_IN_NETHER_FORTRESS > 0 && event.getStructure() == Structure.field_236378_n_) {
            event.addEntitySpawn(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)ModEntityTypes.FORTRESS_KEEPER.get(), ModConfigs.cachedServer.FORTRESS_KEEPER_SPAWN_WEIGHT_IN_NETHER_FORTRESS, 1, 1));
        }
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (ModConfigs.cachedServer.ADDITIONAL_VILLAGER_TRADES && event.getType() != null) {
            Int2ObjectMap trades = event.getTrades();
            if (event.getType() == VillagerProfession.field_221155_e) {
                ((List)trades.get(2)).add(new BasicTrade(new ItemStack((IItemProvider)ModItems.SOUL_POWDER.get(), 24), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 16, 2, 0.05f));
                ((List)trades.get(4)).add(new BasicTrade(new ItemStack((IItemProvider)ModItems.EXP_BERRY.get(), 3), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 16, 15, 0.05f));
                ((List)trades.get(4)).add(new BasicTrade(new ItemStack((IItemProvider)ModItems.SPECTRAL_SOUP.get(), 1), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 16, 15, 0.05f));
            }
            if (event.getType() == VillagerProfession.field_221159_i) {
                ((List)trades.get(3)).add(new BasicTrade(new ItemStack((IItemProvider)ModItems.BAT_WING.get(), 4), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 16, 15, 0.05f));
                if (ModConfigs.cachedServer.KOBOLD_SPAWN_WEIGHT > 0) {
                    ((List)trades.get(4)).add(new BasicTrade(new ItemStack((IItemProvider)ModItems.KOBOLD_LEATHER.get(), 4), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 12, 20, 0.05f));
                }
            }
            if (event.getType() == VillagerProfession.field_221156_f) {
                ((List)trades.get(2)).add(new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 1), new ItemStack((IItemProvider)ModItems.BLUEBERRY.get(), 4), 12, 4, 0.05f));
                ((List)trades.get(2)).add(new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 1), new ItemStack((IItemProvider)ModItems.STRAWBERRY.get(), 4), 12, 4, 0.05f));
                ((List)trades.get(2)).add(new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 1), new ItemStack((IItemProvider)ModItems.LEMON.get(), 4), 12, 4, 0.05f));
            }
            if (event.getType() == VillagerProfession.field_221157_g && (ModConfigs.cachedServer.SAVAGEFANG_SPAWN_WEIGHT_IN_SWAMP > 0 || ModConfigs.cachedServer.SAVAGEFANG_SPAWN_WEIGHT_IN_JUNGLE > 0)) {
                ((List)trades.get(4)).add(new BasicTrade(new ItemStack((IItemProvider)ModItems.SAVAGEFANG_MEAT.get(), 3), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 12, 20, 0.05f));
            }
        }
    }

    @SubscribeEvent
    public void onWandererTrades(WandererTradesEvent event) {
        if (ModConfigs.cachedServer.ADDITIONAL_WANDERER_TRADES) {
            List genericTrades = event.getGenericTrades();
            List rareTrades = event.getRareTrades();
            if (ModConfigs.cachedServer.ENDER_EXECUTOR_REPLACE_CHANCE > 0.0) {
                genericTrades.add(new BasicTrade(new ItemStack((IItemProvider)ModItems.ENDER_PLASM.get(), 1), new ItemStack((IItemProvider)Items.field_151166_bC, 2), 32, 1, 0.05f));
            }
            genericTrades.add(new BasicTrade(new ItemStack((IItemProvider)ModItems.ANCIENT_STONE.get(), 2), new ItemStack((IItemProvider)Items.field_151166_bC, 1), 32, 1, 0.05f));
            genericTrades.add(new BasicTrade(5, new ItemStack((IItemProvider)ModItems.FIRE_BOTTLE.get()), 8, 1, 1.0f));
            rareTrades.add(new BasicTrade(32, new ItemStack((IItemProvider)ModItems.LIGHTNING_PARTICLE.get()), 5, 1, 0.05f));
            rareTrades.add(new BasicTrade(32, new ItemStack((IItemProvider)ModItems.PURIFICATION_CLOTH.get()), 3, 1, 0.05f));
        }
    }
}

