/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.client.model.ZombieGirlModel;
import com.github.mechalopa.hmag.util.ModUtils;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DrownedGirlModel<T extends ZombieEntity>
extends ZombieGirlModel<T> {
    private ModelRenderer rightArmPart;
    private ModelRenderer leftArmPart;

    public DrownedGirlModel() {
        this(0.0f);
    }

    public DrownedGirlModel(float modelSize) {
        this(modelSize, false);
    }

    public DrownedGirlModel(float modelSize, boolean isArmor) {
        super(modelSize, isArmor);
        if (!isArmor) {
            this.field_178723_h = new ModelRenderer((Model)this, 50, 32);
            this.field_178723_h.func_228301_a_(-1.0f, -2.0f, -1.5f, 3.0f, 12.0f, 3.0f, modelSize);
            this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.field_178721_j = new ModelRenderer((Model)this, 50, 48);
            this.field_178721_j.func_228301_a_(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, modelSize);
            this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.rightArmPart = new ModelRenderer((Model)this, 24, 56);
            this.rightArmPart.func_228301_a_(-1.0f, -2.0f, 0.0f, 1.0f, 4.0f, 3.0f, modelSize);
            this.rightArmPart.func_78793_a(-1.0f, 2.0f, 1.5f);
            this.field_178723_h.func_78792_a(this.rightArmPart);
            this.leftArmPart = new ModelRenderer((Model)this, 40, 54);
            this.leftArmPart.func_228301_a_(0.0f, -2.0f, 0.0f, 1.0f, 8.0f, 2.0f, modelSize);
            this.leftArmPart.func_78793_a(1.0f, 2.0f, 1.5f);
            this.field_178724_i.func_78792_a(this.leftArmPart);
        }
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.field_187076_m = BipedModel.ArmPose.EMPTY;
        this.field_187075_l = BipedModel.ArmPose.EMPTY;
        ItemStack stack = entityIn.func_184586_b(Hand.MAIN_HAND);
        if (ModUtils.isTrident(stack) && entityIn.func_213398_dR()) {
            if (entityIn.func_184591_cq() == HandSide.RIGHT) {
                this.field_187076_m = BipedModel.ArmPose.THROW_SPEAR;
            } else {
                this.field_187075_l = BipedModel.ArmPose.THROW_SPEAR;
            }
        }
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
    }

    @Override
    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.field_187075_l == BipedModel.ArmPose.THROW_SPEAR) {
            this.field_178724_i.field_78795_f = this.field_178724_i.field_78795_f * 0.5f - (float)Math.PI;
            this.field_178724_i.field_78796_g = 0.0f;
        }
        if (this.field_187076_m == BipedModel.ArmPose.THROW_SPEAR) {
            this.field_178723_h.field_78795_f = this.field_178723_h.field_78795_f * 0.5f - (float)Math.PI;
            this.field_178723_h.field_78796_g = 0.0f;
        }
        if (this.field_205061_a > 0.0f) {
            this.field_178723_h.field_78795_f = this.func_205060_a(this.field_205061_a, this.field_178723_h.field_78795_f, -2.5132742f) + this.field_205061_a * 0.35f * MathHelper.func_76126_a((float)(0.1f * ageInTicks));
            this.field_178724_i.field_78795_f = this.func_205060_a(this.field_205061_a, this.field_178724_i.field_78795_f, -2.5132742f) - this.field_205061_a * 0.35f * MathHelper.func_76126_a((float)(0.1f * ageInTicks));
            this.field_178723_h.field_78808_h = this.func_205060_a(this.field_205061_a, this.field_178723_h.field_78808_h, -0.15f);
            this.field_178724_i.field_78808_h = this.func_205060_a(this.field_205061_a, this.field_178724_i.field_78808_h, 0.15f);
            this.field_178722_k.field_78795_f -= this.field_205061_a * 0.55f * MathHelper.func_76126_a((float)(0.1f * ageInTicks));
            this.field_178721_j.field_78795_f += this.field_205061_a * 0.55f * MathHelper.func_76126_a((float)(0.1f * ageInTicks));
            this.field_78116_c.field_78795_f = 0.0f;
        }
        this.rightArmPart.field_78796_g = -0.17453294f;
        this.rightArmPart.field_78796_g += MathHelper.func_76126_a((float)(ageInTicks * 0.045f + (float)Math.PI)) * 0.06f;
        this.leftArmPart.field_78796_g = 0.17453294f;
        this.leftArmPart.field_78796_g -= MathHelper.func_76126_a((float)(ageInTicks * 0.045f + (float)Math.PI)) * 0.06f;
        this.field_178720_f.func_217177_a(this.field_78116_c);
    }
}

