/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.entity.AbstractFlyingMonsterEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelHelper;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GhostModel<T extends AbstractFlyingMonsterEntity>
extends BipedModel<T> {
    protected boolean isArmor = false;

    public GhostModel() {
        this(0.0f, false);
    }

    public GhostModel(float modelSize) {
        this(modelSize, 0.0f);
    }

    public GhostModel(boolean isArmor) {
        this(0.0f, isArmor);
    }

    public GhostModel(float modelSize, float yOffsetIn) {
        this(modelSize, yOffsetIn, 64, 64, false);
    }

    public GhostModel(float modelSize, boolean isArmor) {
        this(modelSize, 0.0f, isArmor);
    }

    public GhostModel(float modelSize, float yOffsetIn, boolean isArmor) {
        this(modelSize, yOffsetIn, 64, isArmor ? 32 : 64, isArmor);
    }

    public GhostModel(float modelSize, float yOffsetIn, int textureWidthIn, int textureHeightIn, boolean isArmor) {
        super(modelSize, yOffsetIn, textureWidthIn, textureHeightIn);
        this.isArmor = isArmor;
        if (!isArmor) {
            this.field_78115_e = new ModelRenderer((Model)this, 16, 16);
            this.field_78115_e.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 20.0f, 4.0f, modelSize);
            this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_178721_j = new ModelRenderer((Model)this, 0, 16);
            this.field_178721_j.func_228301_a_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, modelSize);
            this.field_178721_j.func_78793_a(-2.0f, 12.0f, 0.0f);
            this.field_178722_k = new ModelRenderer((Model)this, 0, 16);
            this.field_178722_k.field_78809_i = true;
            this.field_178722_k.func_228301_a_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, modelSize);
            this.field_178722_k.func_78793_a(2.0f, 12.0f, 0.0f);
        }
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ModelHelper.func_239105_a_((ModelRenderer)this.field_178724_i, (ModelRenderer)this.field_178723_h, (boolean)((AbstractFlyingMonsterEntity)((Object)entityIn)).isCharging(), (float)this.field_217112_c, (float)ageInTicks);
        float f = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)((1.0f - (1.0f - this.field_217112_c) * (1.0f - this.field_217112_c)) * (float)Math.PI));
        this.field_178721_j.field_78795_f = 0.1308997f;
        this.field_178722_k.field_78795_f = 0.1308997f;
        this.field_178721_j.field_78808_h = 0.116355285f;
        this.field_178722_k.field_78808_h = -0.116355285f;
        this.field_178721_j.field_78795_f -= f * 1.2f - f1 * 0.4f;
        this.field_178722_k.field_78795_f -= f * 1.2f - f1 * 0.4f;
        this.field_178721_j.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.067f)) * 0.05f;
        this.field_178722_k.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.067f)) * 0.05f;
        this.field_178721_j.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.033f)) * 0.025f;
        this.field_178722_k.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.033f)) * 0.025f;
    }
}

