/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MagicalSlimeModel<T extends Entity>
extends SegmentedModel<T> {
    private final ModelRenderer cube;
    private final ModelRenderer eye0;
    private final ModelRenderer eye1;
    private final ModelRenderer mouth;
    private final boolean isLayer;

    public MagicalSlimeModel(int slimeBodyTexOffY) {
        this.cube = new ModelRenderer((Model)this, 0, slimeBodyTexOffY);
        this.eye0 = new ModelRenderer((Model)this, 32, 0);
        this.eye1 = new ModelRenderer((Model)this, 32, 4);
        this.mouth = new ModelRenderer((Model)this, 32, 8);
        if (slimeBodyTexOffY > 0) {
            this.cube.func_228301_a_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, -0.75f);
            this.cube.func_78793_a(0.0f, 20.0f, 0.0f);
            this.eye0.func_228300_a_(-3.25f, 18.0f, -3.5f, 2.0f, 2.0f, 2.0f);
            this.eye1.func_228300_a_(1.25f, 18.0f, -3.5f, 2.0f, 2.0f, 2.0f);
            this.mouth.func_228300_a_(0.0f, 21.0f, -3.5f, 1.0f, 1.0f, 1.0f);
            this.isLayer = false;
        } else {
            this.cube.func_228300_a_(-4.0f, 16.0f, -4.0f, 8.0f, 8.0f, 8.0f);
            this.isLayer = true;
        }
    }

    public void func_225597_a_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.isLayer) {
            this.cube.field_78795_f = MathHelper.func_76126_a((float)(ageInTicks * 0.09f)) * 0.075f;
            this.cube.field_78808_h = MathHelper.func_76134_b((float)(ageInTicks * 0.06f)) * 0.075f;
        }
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.cube, (Object)this.eye0, (Object)this.eye1, (Object)this.mouth);
    }
}

