/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.model;

import com.github.mechalopa.hmag.entity.StoneularEntity;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StoneularModel<T extends StoneularEntity>
extends SegmentedModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer headPart1;
    private final ModelRenderer headPart2;
    private final ModelRenderer headPart3;
    private final ModelRenderer rightLeg;
    private final ModelRenderer leftLeg;
    private final ModelRenderer rightLegPart1;
    private final ModelRenderer leftLegPart1;
    private final ModelRenderer rightLegPart2;
    private final ModelRenderer leftLegPart2;
    private final ModelRenderer hornBase;
    private final ModelRenderer hornPart1;
    private final ModelRenderer hornPart2;
    private final ModelRenderer bristle0;
    private final ModelRenderer bristle1;
    private final ModelRenderer bristle2;
    private final ModelRenderer bristle3;
    private final ModelRenderer faceBristle;
    private float animationAmount;

    public StoneularModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_228300_a_(-8.0f, -6.0f, -8.0f, 16.0f, 14.0f, 5.0f);
        this.head.func_78793_a(0.0f, 1.0f, 0.0f);
        this.headPart1 = new ModelRenderer((Model)this, 0, 24);
        this.headPart1.func_228300_a_(-7.0f, -5.0f, -8.0f, 14.0f, 12.0f, 6.0f);
        this.headPart1.func_78793_a(0.0f, 0.0f, 5.0f);
        this.head.func_78792_a(this.headPart1);
        this.headPart2 = new ModelRenderer((Model)this, 48, 0);
        this.headPart2.func_228300_a_(-8.0f, -6.0f, -8.0f, 16.0f, 14.0f, 5.0f);
        this.headPart2.func_78793_a(0.0f, 0.0f, 6.0f);
        this.headPart1.func_78792_a(this.headPart2);
        this.headPart3 = new ModelRenderer((Model)this, 48, 24);
        this.headPart3.func_228300_a_(-3.0f, -3.0f, -1.0f, 6.0f, 6.0f, 1.0f);
        this.headPart3.func_78793_a(0.0f, -2.0f, -8.0f);
        this.head.func_78792_a(this.headPart3);
        this.rightLeg = new ModelRenderer((Model)this, 0, 48);
        this.rightLeg.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f);
        this.rightLeg.func_78793_a(-4.0f, 8.0f, 0.0f);
        this.leftLeg = new ModelRenderer((Model)this, 0, 48);
        this.leftLeg.field_78809_i = true;
        this.leftLeg.func_228300_a_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f);
        this.leftLeg.func_78793_a(4.0f, 8.0f, 0.0f);
        this.rightLegPart1 = new ModelRenderer((Model)this, 16, 48);
        this.rightLegPart1.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 3.0f, 6.0f);
        this.rightLegPart1.func_78793_a(0.0f, 4.0f, 0.0f);
        this.rightLeg.func_78792_a(this.rightLegPart1);
        this.leftLegPart1 = new ModelRenderer((Model)this, 40, 48);
        this.leftLegPart1.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 3.0f, 6.0f);
        this.leftLegPart1.func_78793_a(0.0f, 4.0f, 0.0f);
        this.leftLeg.func_78792_a(this.leftLegPart1);
        this.rightLegPart2 = new ModelRenderer((Model)this, 16, 60);
        this.rightLegPart2.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 7.0f, 6.0f);
        this.rightLegPart2.func_78793_a(0.0f, 9.0f, 0.0f);
        this.rightLeg.func_78792_a(this.rightLegPart2);
        this.leftLegPart2 = new ModelRenderer((Model)this, 40, 60);
        this.leftLegPart2.func_228300_a_(-3.0f, 0.0f, -3.0f, 6.0f, 7.0f, 6.0f);
        this.leftLegPart2.func_78793_a(0.0f, 9.0f, 0.0f);
        this.leftLeg.func_78792_a(this.leftLegPart2);
        this.hornBase = new ModelRenderer((Model)this, 48, 32);
        this.hornBase.func_228300_a_(-2.0f, -2.0f, -5.0f, 4.0f, 4.0f, 5.0f);
        this.hornBase.func_78793_a(0.0f, -1.0f, -6.0f);
        this.head.func_78792_a(this.hornBase);
        this.hornPart1 = new ModelRenderer((Model)this, 48, 42);
        this.hornPart1.func_228300_a_(-1.5f, -1.5f, -2.0f, 3.0f, 3.0f, 2.0f);
        this.hornPart1.func_78793_a(0.0f, 0.0f, -5.0f);
        this.hornBase.func_78792_a(this.hornPart1);
        this.hornPart2 = new ModelRenderer((Model)this, 64, 42);
        this.hornPart2.func_228300_a_(-1.0f, -1.0f, -3.0f, 2.0f, 2.0f, 3.0f);
        this.hornPart2.func_78793_a(0.0f, 0.0f, -2.0f);
        this.hornPart1.func_78792_a(this.hornPart2);
        this.bristle0 = new ModelRenderer((Model)this, 0, 80);
        this.bristle0.func_228303_a_(0.0f, 0.0f, -8.0f, 1.0f, 4.0f, 16.0f, 0.0f, true);
        this.bristle0.func_78793_a(-6.0f, 8.0f, 0.0f);
        this.head.func_78792_a(this.bristle0);
        this.bristle1 = new ModelRenderer((Model)this, 0, 80);
        this.bristle1.func_228301_a_(-1.0f, 0.0f, -8.0f, 1.0f, 4.0f, 16.0f, 0.0f);
        this.bristle1.func_78793_a(6.0f, 8.0f, 0.0f);
        this.head.func_78792_a(this.bristle1);
        this.bristle2 = new ModelRenderer((Model)this, 48, 80);
        this.bristle2.func_228303_a_(0.0f, 0.0f, -4.0f, 1.0f, 6.0f, 8.0f, 0.0f, true);
        this.bristle2.func_78793_a(-7.0f, 6.0f, 0.0f);
        this.head.func_78792_a(this.bristle2);
        this.bristle3 = new ModelRenderer((Model)this, 48, 80);
        this.bristle3.func_228301_a_(-1.0f, 0.0f, -4.0f, 1.0f, 6.0f, 8.0f, 0.0f);
        this.bristle3.func_78793_a(7.0f, 6.0f, 0.0f);
        this.head.func_78792_a(this.bristle3);
        this.faceBristle = new ModelRenderer((Model)this, 0, 104);
        this.faceBristle.func_228301_a_(-8.0f, 0.0f, 0.0f, 16.0f, 3.0f, 1.0f, 0.0f);
        this.faceBristle.func_78793_a(0.0f, 8.0f, -8.0f);
        this.head.func_78792_a(this.faceBristle);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.head, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.animationAmount = MathHelper.func_76131_a((float)((StoneularEntity)entityIn).getAnimationScale(partialTick), (float)0.0f, (float)1.0f);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((StoneularEntity)entityIn).isWalking()) {
            this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
            this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        } else {
            this.head.field_78795_f = 0.0f;
            this.head.field_78796_g = 0.0f;
        }
        float f = 1.75f;
        float f1 = 1.0f - this.animationAmount;
        limbSwingAmount = Math.min(0.25f, limbSwingAmount) * f1;
        this.head.field_78808_h = 0.1f * MathHelper.func_76126_a((float)(limbSwing * f)) * 4.0f * limbSwingAmount;
        this.head.field_78797_d = this.animationAmount * 13.0f + 2.0f;
        this.head.field_78797_d -= 2.0f * MathHelper.func_76134_b((float)(limbSwing * f)) * 2.0f * limbSwingAmount;
        this.leftLeg.field_78795_f = MathHelper.func_76126_a((float)(limbSwing * f * 0.5f)) * 2.0f * limbSwingAmount;
        this.rightLeg.field_78795_f = MathHelper.func_76126_a((float)(limbSwing * f * 0.5f + (float)Math.PI)) * 2.0f * limbSwingAmount;
        this.leftLeg.field_78808_h = 0.17453292f * MathHelper.func_76134_b((float)(limbSwing * f * 0.5f)) * limbSwingAmount;
        this.rightLeg.field_78808_h = 0.17453292f * MathHelper.func_76134_b((float)(limbSwing * f * 0.5f + (float)Math.PI)) * limbSwingAmount;
        float f2 = this.animationAmount * 3.0f + 8.0f;
        this.leftLeg.field_78797_d = f2 + 2.0f * MathHelper.func_76126_a((float)(limbSwing * f * 0.5f + (float)Math.PI)) * 2.0f * limbSwingAmount;
        this.rightLeg.field_78797_d = f2 + 2.0f * MathHelper.func_76126_a((float)(limbSwing * f * 0.5f)) * 2.0f * limbSwingAmount;
        float f3 = this.animationAmount * (float)Math.PI;
        this.leftLeg.field_78808_h -= f3;
        this.rightLeg.field_78808_h += f3;
        float f4 = (1.0f - Math.abs(this.animationAmount * 2.0f - 1.0f)) * 2.0f;
        this.leftLeg.field_78800_c = 4.0f + f4;
        this.rightLeg.field_78800_c = -4.0f - f4;
        this.hornBase.field_78795_f = -0.2617994f * f1;
        this.hornBase.field_78796_g = 0.25f * MathHelper.func_76134_b((float)(limbSwing * f * 0.5f)) * limbSwingAmount;
        this.hornBase.field_78798_e = -6.0f + this.animationAmount * 6.0f;
        this.hornPart1.field_78798_e = -5.0f + this.animationAmount * 2.5f;
        this.hornPart2.field_78798_e = -2.0f + this.animationAmount * 1.5f;
        this.bristle0.field_78808_h = 0.1308997f;
        this.bristle1.field_78808_h = -0.1308997f;
        this.bristle2.field_78808_h = 0.116355285f;
        this.bristle3.field_78808_h = -0.116355285f;
        float f5 = MathHelper.func_76134_b((float)(limbSwing * 1.5f + (float)Math.PI)) * limbSwingAmount;
        this.bristle0.field_78808_h += f5 * 1.3f;
        this.bristle1.field_78808_h += f5 * 1.3f;
        this.bristle2.field_78808_h += f5 * 1.2f;
        this.bristle3.field_78808_h += f5 * 1.2f;
        this.bristle0.field_78808_h += 0.05f * MathHelper.func_76126_a((float)(ageInTicks * 1.0f * 0.2f));
        this.bristle1.field_78808_h += 0.05f * MathHelper.func_76126_a((float)(ageInTicks * 1.0f * 0.2f));
        this.bristle2.field_78808_h += 0.05f * MathHelper.func_76126_a((float)(ageInTicks * 1.0f * -0.3f));
        this.bristle3.field_78808_h += 0.05f * MathHelper.func_76126_a((float)(ageInTicks * 1.0f * -0.3f));
        this.faceBristle.field_78795_f = 0.1308997f;
        this.faceBristle.field_78795_f += f5 * 1.2f;
        this.faceBristle.field_78795_f += 0.05f * MathHelper.func_76126_a((float)(ageInTicks * 1.0f * 0.3f));
    }
}

