/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.model.DyssomniaModel;
import com.github.mechalopa.hmag.client.renderer.layers.DyssomniaEyesLayer;
import com.github.mechalopa.hmag.entity.DyssomniaEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DyssomniaRenderer
extends MobRenderer<DyssomniaEntity, DyssomniaModel<DyssomniaEntity>> {
    private static final ResourceLocation TEX = new ResourceLocation("hmag", "textures/entity/dyssomnia.png");
    private final Random rand = new Random();

    public DyssomniaRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new DyssomniaModel(), 1.2f);
        this.func_177094_a((LayerRenderer)new DyssomniaEyesLayer(this));
    }

    protected void scale(DyssomniaEntity entityIn, MatrixStack matrixStackIn, float partialTickTime) {
        matrixStackIn.func_227862_a_(1.75f, 1.75f, 1.75f);
        matrixStackIn.func_227861_a_(0.0, 1.25, 0.0);
    }

    protected void setupRotations(DyssomniaEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(entityLiving.getXRotAnimationScale(partialTicks) * 180.0f));
    }

    public Vector3d getRenderOffset(DyssomniaEntity entityIn, float partialTicks) {
        if (entityIn.getAttackingTime() >= 0 && entityIn.getAttackPhase() == DyssomniaEntity.AttackPhase.SUMMON) {
            return new Vector3d(this.rand.nextGaussian() * 0.03, this.rand.nextGaussian() * 0.03, this.rand.nextGaussian() * 0.03);
        }
        return super.func_225627_b_((Entity)entityIn, partialTicks);
    }

    public ResourceLocation getTextureLocation(DyssomniaEntity entityIn) {
        return TEX;
    }
}

