/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.model.EnderExecutorModel;
import com.github.mechalopa.hmag.client.renderer.layers.EnderExecutorEyesLayer;
import com.github.mechalopa.hmag.client.renderer.layers.EnderExecutorHeldBlockLayer;
import com.github.mechalopa.hmag.client.renderer.layers.HeldItemLayer2;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.entity.EnderExecutorEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnderExecutorRenderer
extends MobRenderer<EnderExecutorEntity, EnderExecutorModel<EnderExecutorEntity>> {
    private static final ResourceLocation TEX = new ResourceLocation("hmag", "textures/entity/ender_executor.png");
    private static final ResourceLocation BEAM_TEX = new ResourceLocation("hmag", "textures/entity/ender_executor_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.func_228640_c_((ResourceLocation)BEAM_TEX);
    private final Random rand = new Random();

    public EnderExecutorRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new EnderExecutorModel(), 0.5f);
        this.func_177094_a(new EnderExecutorEyesLayer(this));
        this.func_177094_a((LayerRenderer)new HeldItemLayer2(this, -1));
        this.func_177094_a(new EnderExecutorHeldBlockLayer((IEntityRenderer<EnderExecutorEntity, EnderExecutorModel<EnderExecutorEntity>>)this));
    }

    public boolean shouldRender(EnderExecutorEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        if (super.func_225626_a_((MobEntity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        return ModClientUtils.shouldRenderBeamAttackMob((LivingEntity)livingEntityIn, camera, camX, camY, camZ, livingEntityIn);
    }

    public void render(EnderExecutorEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        BlockState blockstate = entityIn.func_195405_dq();
        EnderExecutorModel endermanmodel = (EnderExecutorModel)this.func_217764_d();
        endermanmodel.isCarrying = blockstate != null;
        endermanmodel.isAttacking = entityIn.func_70823_r();
        LivingEntity target = entityIn.getActiveAttackTarget();
        endermanmodel.isBeamAttacking = entityIn.hasActiveAttackTarget() && target != null;
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (entityIn.func_70089_S() && target != null) {
            float f = entityIn.getAttackAnimationScale(partialTicks);
            float f1 = (float)(entityIn.field_70170_p.func_82737_E() % 24000L) + partialTicks;
            float f2 = f1 * 0.5f % 1.0f;
            float f3 = entityIn.func_70047_e();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)f3 + (double)entityIn.func_213302_cg() * 0.05, 0.0);
            Vector3d vector3d = ModClientUtils.getPosition(target, (double)target.func_213302_cg() * 0.5, partialTicks);
            Vector3d vector3d1 = ModClientUtils.getPosition((LivingEntity)entityIn, f3, partialTicks);
            Vector3d vector3d2 = vector3d.func_178788_d(vector3d1);
            float f4 = (float)(vector3d2.func_72433_c() + 1.0);
            vector3d2 = vector3d2.func_72432_b();
            float f5 = (float)Math.acos(vector3d2.field_72448_b);
            float f6 = (float)Math.atan2(vector3d2.field_72449_c, vector3d2.field_72450_a);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - f6) * 57.295776f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f5 * 57.295776f));
            float f7 = 0.0f;
            float f8 = f * f;
            int i = 200 + (int)(f8 * 4.0f);
            int j = 235 - (int)(f8 * 141.0f);
            int k = 235 + (int)(f8 * 17.0f);
            float f11 = MathHelper.func_76134_b((float)(f7 + 2.3561945f)) * 0.282f;
            float f12 = MathHelper.func_76126_a((float)(f7 + 2.3561945f)) * 0.282f;
            float f13 = MathHelper.func_76134_b((float)(f7 + 0.7853982f)) * 0.282f;
            float f14 = MathHelper.func_76126_a((float)(f7 + 0.7853982f)) * 0.282f;
            float f15 = MathHelper.func_76134_b((float)(f7 + 3.926991f)) * 0.282f;
            float f16 = MathHelper.func_76126_a((float)(f7 + 3.926991f)) * 0.282f;
            float f17 = MathHelper.func_76134_b((float)(f7 + 5.4977875f)) * 0.282f;
            float f18 = MathHelper.func_76126_a((float)(f7 + 5.4977875f)) * 0.282f;
            float f19 = MathHelper.func_76134_b((float)(f7 + (float)Math.PI)) * 0.2f;
            float f20 = MathHelper.func_76126_a((float)(f7 + (float)Math.PI)) * 0.2f;
            float f21 = MathHelper.func_76134_b((float)(f7 + 0.0f)) * 0.2f;
            float f22 = MathHelper.func_76126_a((float)(f7 + 0.0f)) * 0.2f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(BEAM_RENDER_TYPE);
            MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
            Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
            Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, i, j, k, 0.5f, f30);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, i, j, k, 0.5f, f29);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, i, j, k, 0.0f, f29);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, i, j, k, 0.0f, f30);
            float f31 = entityIn.field_70173_aa % 2 == 0 ? 0.5f : 0.0f;
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, i, j, k, 0.5f, f31 + 0.5f);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, i, j, k, 1.0f, f31 + 0.5f);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, i, j, k, 1.0f, f31);
            ModClientUtils.drawVertex(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, i, j, k, 0.5f, f31);
            matrixStackIn.func_227865_b_();
        }
    }

    public Vector3d getRenderOffset(EnderExecutorEntity entityIn, float partialTicks) {
        if (entityIn.func_70823_r()) {
            return new Vector3d(this.rand.nextGaussian() * 0.02, 0.0, this.rand.nextGaussian() * 0.02);
        }
        return super.func_225627_b_((Entity)entityIn, partialTicks);
    }

    public ResourceLocation getTextureLocation(EnderExecutorEntity entityIn) {
        return TEX;
    }
}

