/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.model.GhostModel;
import com.github.mechalopa.hmag.client.renderer.layers.GhostClothingLayer;
import com.github.mechalopa.hmag.entity.GhostEntity;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GhostRenderer
extends BipedRenderer<GhostEntity, GhostModel<GhostEntity>> {
    private static final ResourceLocation TEX0 = new ResourceLocation("hmag", "textures/entity/ghost_0.png");
    private static final ResourceLocation TEX1 = new ResourceLocation("hmag", "textures/entity/ghost_1.png");
    private static final ResourceLocation TEX2 = new ResourceLocation("hmag", "textures/entity/ghost_2.png");
    private static final ResourceLocation TEX3 = new ResourceLocation("hmag", "textures/entity/ghost_3.png");
    private static final ResourceLocation TEX4 = new ResourceLocation("hmag", "textures/entity/ghost_4.png");

    public GhostRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new GhostModel(), 0.375f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new GhostModel(0.5f, true), new GhostModel(1.0f, true)));
        this.func_177094_a(this.getLayer());
    }

    protected int getBlockLightLevel(GhostEntity entityIn, BlockPos pos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(GhostEntity entityIn) {
        switch (entityIn.getVariant()) {
            case 1: {
                return TEX1;
            }
            case 2: {
                return TEX2;
            }
            case 3: {
                return TEX3;
            }
            case 4: {
                return TEX4;
            }
        }
        return TEX0;
    }

    public GhostClothingLayer getLayer() {
        return new GhostClothingLayer((IEntityRenderer<GhostEntity, GhostModel<GhostEntity>>)this);
    }
}

